/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthUI;
import javax.swing.text.View;

public class SynthButtonUI
extends BasicButtonUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;

    public static ComponentUI createUI(JComponent c) {
        return new SynthButtonUI();
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        this.updateStyle(b);
        LookAndFeel.installProperty(b, "rolloverEnabled", Boolean.TRUE);
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        b.addPropertyChangeListener(this);
    }

    void updateStyle(AbstractButton b) {
        SynthContext context = this.getContext(b, 1);
        SynthStyle oldStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle) {
            Object value;
            if (b.getMargin() == null || b.getMargin() instanceof UIResource) {
                Insets margin = (Insets)this.style.get(context, this.getPropertyPrefix() + "margin");
                if (margin == null) {
                    margin = SynthLookAndFeel.EMPTY_UIRESOURCE_INSETS;
                }
                b.setMargin(margin);
            }
            if ((value = this.style.get(context, this.getPropertyPrefix() + "iconTextGap")) != null) {
                LookAndFeel.installProperty(b, "iconTextGap", value);
            }
            LookAndFeel.installProperty(b, "contentAreaFilled", (value = this.style.get(context, this.getPropertyPrefix() + "contentAreaFilled")) != null ? value : Boolean.TRUE);
            if (oldStyle != null) {
                this.uninstallKeyboardActions(b);
                this.installKeyboardActions(b);
            }
        }
        context.dispose();
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        super.uninstallListeners(b);
        b.removePropertyChangeListener(this);
    }

    @Override
    protected void uninstallDefaults(AbstractButton b) {
        SynthContext context = this.getContext(b, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
    }

    @Override
    public SynthContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(c, this.style, state);
    }

    private int getComponentState(JComponent c) {
        int state = 1;
        if (!c.isEnabled()) {
            state = 8;
        }
        if (SynthLookAndFeel.getSelectedUI() == this) {
            return SynthLookAndFeel.getSelectedUIState() | 1;
        }
        AbstractButton button = (AbstractButton)c;
        ButtonModel model = button.getModel();
        if (model.isPressed()) {
            state = model.isArmed() ? 4 : 2;
        }
        if (model.isRollover()) {
            state |= 2;
        }
        if (model.isSelected()) {
            state |= 0x200;
        }
        if (c.isFocusOwner() && button.isFocusPainted()) {
            state |= 0x100;
        }
        if (c instanceof JButton && ((JButton)c).isDefaultButton()) {
            state |= 0x400;
        }
        return state;
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        int baseline;
        if (c == null) {
            throw new NullPointerException("Component must be non-null");
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("Width and height must be >= 0");
        }
        AbstractButton b = (AbstractButton)c;
        String text = b.getText();
        if (text == null || "".equals(text)) {
            return -1;
        }
        Insets i = b.getInsets();
        Rectangle viewRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Rectangle iconRect = new Rectangle();
        viewRect.x = i.left;
        viewRect.y = i.top;
        viewRect.width = width - (i.right + viewRect.x);
        viewRect.height = height - (i.bottom + viewRect.y);
        SynthContext context = this.getContext(b);
        FontMetrics fm = context.getComponent().getFontMetrics(context.getStyle().getFont(context));
        context.getStyle().getGraphicsUtils(context).layoutText(context, fm, b.getText(), b.getIcon(), b.getHorizontalAlignment(), b.getVerticalAlignment(), b.getHorizontalTextPosition(), b.getVerticalTextPosition(), viewRect, iconRect, textRect, b.getIconTextGap());
        View view = (View)b.getClientProperty("html");
        if (view != null) {
            baseline = BasicHTML.getHTMLBaseline(view, textRect.width, textRect.height);
            if (baseline >= 0) {
                baseline += textRect.y;
            }
        } else {
            baseline = textRect.y + fm.getAscent();
        }
        context.dispose();
        return baseline;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        this.paintBackground(context, g, c);
        this.paint(context, g);
        context.dispose();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SynthContext context, Graphics g) {
        AbstractButton b = (AbstractButton)context.getComponent();
        g.setColor(context.getStyle().getColor(context, ColorType.TEXT_FOREGROUND));
        g.setFont(this.style.getFont(context));
        context.getStyle().getGraphicsUtils(context).paintText(context, g, b.getText(), this.getIcon(b), b.getHorizontalAlignment(), b.getVerticalAlignment(), b.getHorizontalTextPosition(), b.getVerticalTextPosition(), b.getIconTextGap(), b.getDisplayedMnemonicIndex(), this.getTextShiftOffset(context));
    }

    void paintBackground(SynthContext context, Graphics g, JComponent c) {
        if (((AbstractButton)c).isContentAreaFilled()) {
            context.getPainter().paintButtonBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        }
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintButtonBorder(context, g, x, y, w, h);
    }

    protected Icon getDefaultIcon(AbstractButton b) {
        SynthContext context = this.getContext(b);
        Icon icon = context.getStyle().getIcon(context, this.getPropertyPrefix() + "icon");
        context.dispose();
        return icon;
    }

    protected Icon getIcon(AbstractButton b) {
        Icon icon = b.getIcon();
        ButtonModel model = b.getModel();
        icon = !model.isEnabled() ? this.getSynthDisabledIcon(b, icon) : (model.isPressed() && model.isArmed() ? this.getPressedIcon(b, this.getSelectedIcon(b, icon)) : (b.isRolloverEnabled() && model.isRollover() ? this.getRolloverIcon(b, this.getSelectedIcon(b, icon)) : (model.isSelected() ? this.getSelectedIcon(b, icon) : this.getEnabledIcon(b, icon))));
        if (icon == null) {
            return this.getDefaultIcon(b);
        }
        return icon;
    }

    private Icon getIcon(AbstractButton b, Icon specificIcon, Icon defaultIcon, int state) {
        Icon icon = specificIcon;
        if (icon == null) {
            if (defaultIcon instanceof UIResource) {
                icon = this.getSynthIcon(b, state);
                if (icon == null) {
                    icon = defaultIcon;
                }
            } else {
                icon = defaultIcon;
            }
        }
        return icon;
    }

    private Icon getSynthIcon(AbstractButton b, int synthConstant) {
        return this.style.getIcon(this.getContext(b, synthConstant), this.getPropertyPrefix() + "icon");
    }

    private Icon getEnabledIcon(AbstractButton b, Icon defaultIcon) {
        if (defaultIcon == null) {
            defaultIcon = this.getSynthIcon(b, 1);
        }
        return defaultIcon;
    }

    private Icon getSelectedIcon(AbstractButton b, Icon defaultIcon) {
        return this.getIcon(b, b.getSelectedIcon(), defaultIcon, 512);
    }

    private Icon getRolloverIcon(AbstractButton b, Icon defaultIcon) {
        ButtonModel model = b.getModel();
        Icon icon = model.isSelected() ? this.getIcon(b, b.getRolloverSelectedIcon(), defaultIcon, 514) : this.getIcon(b, b.getRolloverIcon(), defaultIcon, 2);
        return icon;
    }

    private Icon getPressedIcon(AbstractButton b, Icon defaultIcon) {
        return this.getIcon(b, b.getPressedIcon(), defaultIcon, 4);
    }

    private Icon getSynthDisabledIcon(AbstractButton b, Icon defaultIcon) {
        ButtonModel model = b.getModel();
        Icon icon = model.isSelected() ? this.getIcon(b, b.getDisabledSelectedIcon(), defaultIcon, 520) : this.getIcon(b, b.getDisabledIcon(), defaultIcon, 8);
        return icon;
    }

    private int getTextShiftOffset(SynthContext state) {
        AbstractButton button = (AbstractButton)state.getComponent();
        ButtonModel model = button.getModel();
        if (model.isArmed() && model.isPressed() && button.getPressedIcon() == null) {
            return state.getStyle().getInt(state, this.getPropertyPrefix() + "textShiftOffset", 0);
        }
        return 0;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        if (c.getComponentCount() > 0 && c.getLayout() != null) {
            return null;
        }
        AbstractButton b = (AbstractButton)c;
        SynthContext ss = this.getContext(c);
        Dimension size = ss.getStyle().getGraphicsUtils(ss).getMinimumSize(ss, ss.getStyle().getFont(ss), b.getText(), this.getSizingIcon(b), b.getHorizontalAlignment(), b.getVerticalAlignment(), b.getHorizontalTextPosition(), b.getVerticalTextPosition(), b.getIconTextGap(), b.getDisplayedMnemonicIndex());
        ss.dispose();
        return size;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (c.getComponentCount() > 0 && c.getLayout() != null) {
            return null;
        }
        AbstractButton b = (AbstractButton)c;
        SynthContext ss = this.getContext(c);
        Dimension size = ss.getStyle().getGraphicsUtils(ss).getPreferredSize(ss, ss.getStyle().getFont(ss), b.getText(), this.getSizingIcon(b), b.getHorizontalAlignment(), b.getVerticalAlignment(), b.getHorizontalTextPosition(), b.getVerticalTextPosition(), b.getIconTextGap(), b.getDisplayedMnemonicIndex());
        ss.dispose();
        return size;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        if (c.getComponentCount() > 0 && c.getLayout() != null) {
            return null;
        }
        AbstractButton b = (AbstractButton)c;
        SynthContext ss = this.getContext(c);
        Dimension size = ss.getStyle().getGraphicsUtils(ss).getMaximumSize(ss, ss.getStyle().getFont(ss), b.getText(), this.getSizingIcon(b), b.getHorizontalAlignment(), b.getVerticalAlignment(), b.getHorizontalTextPosition(), b.getVerticalTextPosition(), b.getIconTextGap(), b.getDisplayedMnemonicIndex());
        ss.dispose();
        return size;
    }

    protected Icon getSizingIcon(AbstractButton b) {
        Icon icon = this.getEnabledIcon(b, b.getIcon());
        if (icon == null) {
            icon = this.getDefaultIcon(b);
        }
        return icon;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (SynthLookAndFeel.shouldUpdateStyle(e)) {
            this.updateStyle((AbstractButton)e.getSource());
        }
    }
}

