/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import sun.swing.SwingUtilities2;

public class VariableHeightLayoutCache
extends AbstractLayoutCache {
    private Vector<Object> visibleNodes;
    private boolean updateNodeSizes;
    private TreeStateNode root;
    private Rectangle boundsBuffer;
    private Hashtable<TreePath, TreeStateNode> treePathMapping;
    private Stack<Stack<TreePath>> tempStacks = new Stack();

    public VariableHeightLayoutCache() {
        this.visibleNodes = new Vector();
        this.boundsBuffer = new Rectangle();
        this.treePathMapping = new Hashtable();
    }

    @Override
    public void setModel(TreeModel newModel) {
        super.setModel(newModel);
        this.rebuild(false);
    }

    @Override
    public void setRootVisible(boolean rootVisible) {
        if (this.isRootVisible() != rootVisible && this.root != null) {
            if (rootVisible) {
                this.root.updatePreferredSize(0);
                this.visibleNodes.insertElementAt(this.root, 0);
            } else if (this.visibleNodes.size() > 0) {
                this.visibleNodes.removeElementAt(0);
                if (this.treeSelectionModel != null) {
                    this.treeSelectionModel.removeSelectionPath(this.root.getTreePath());
                }
            }
            if (this.treeSelectionModel != null) {
                this.treeSelectionModel.resetRowSelection();
            }
            if (this.getRowCount() > 0) {
                this.getNode(0).setYOrigin(0);
            }
            this.updateYLocationsFrom(0);
            this.visibleNodesChanged();
        }
        super.setRootVisible(rootVisible);
    }

    @Override
    public void setRowHeight(int rowHeight) {
        if (rowHeight != this.getRowHeight()) {
            super.setRowHeight(rowHeight);
            this.invalidateSizes();
            this.visibleNodesChanged();
        }
    }

    @Override
    public void setNodeDimensions(AbstractLayoutCache.NodeDimensions nd) {
        super.setNodeDimensions(nd);
        this.invalidateSizes();
        this.visibleNodesChanged();
    }

    @Override
    public void setExpandedState(TreePath path, boolean isExpanded) {
        if (path != null) {
            if (isExpanded) {
                this.ensurePathIsExpanded(path, true);
            } else {
                TreeStateNode node = this.getNodeForPath(path, false, true);
                if (node != null) {
                    node.makeVisible();
                    node.collapse();
                }
            }
        }
    }

    @Override
    public boolean getExpandedState(TreePath path) {
        TreeStateNode node = this.getNodeForPath(path, true, false);
        return node != null ? node.isVisible() && node.isExpanded() : false;
    }

    @Override
    public Rectangle getBounds(TreePath path, Rectangle placeIn) {
        TreeStateNode node = this.getNodeForPath(path, true, false);
        if (node != null) {
            if (this.updateNodeSizes) {
                this.updateNodeSizes(false);
            }
            return node.getNodeBounds(placeIn);
        }
        return null;
    }

    @Override
    public TreePath getPathForRow(int row) {
        if (row >= 0 && row < this.getRowCount()) {
            return this.getNode(row).getTreePath();
        }
        return null;
    }

    @Override
    public int getRowForPath(TreePath path) {
        if (path == null) {
            return -1;
        }
        TreeStateNode visNode = this.getNodeForPath(path, true, false);
        if (visNode != null) {
            return visNode.getRow();
        }
        return -1;
    }

    @Override
    public int getRowCount() {
        return this.visibleNodes.size();
    }

    @Override
    public void invalidatePathBounds(TreePath path) {
        TreeStateNode node = this.getNodeForPath(path, true, false);
        if (node != null) {
            node.markSizeInvalid();
            if (node.isVisible()) {
                this.updateYLocationsFrom(node.getRow());
            }
        }
    }

    @Override
    public int getPreferredHeight() {
        int rowCount = this.getRowCount();
        if (rowCount > 0) {
            TreeStateNode node = this.getNode(rowCount - 1);
            return node.getYOrigin() + node.getPreferredHeight();
        }
        return 0;
    }

    @Override
    public int getPreferredWidth(Rectangle bounds) {
        if (this.updateNodeSizes) {
            this.updateNodeSizes(false);
        }
        return this.getMaxNodeWidth();
    }

    @Override
    public TreePath getPathClosestTo(int x, int y) {
        if (this.getRowCount() == 0) {
            return null;
        }
        if (this.updateNodeSizes) {
            this.updateNodeSizes(false);
        }
        int row = this.getRowContainingYLocation(y);
        return this.getNode(row).getTreePath();
    }

    @Override
    public Enumeration<TreePath> getVisiblePathsFrom(TreePath path) {
        TreeStateNode node = this.getNodeForPath(path, true, false);
        if (node != null) {
            return new VisibleTreeStateNodeEnumeration(node);
        }
        return null;
    }

    @Override
    public int getVisibleChildCount(TreePath path) {
        TreeStateNode node = this.getNodeForPath(path, true, false);
        return node != null ? node.getVisibleChildCount() : 0;
    }

    @Override
    public void invalidateSizes() {
        if (this.root != null) {
            this.root.deepMarkSizeInvalid();
        }
        if (!this.isFixedRowHeight() && this.visibleNodes.size() > 0) {
            this.updateNodeSizes(true);
        }
    }

    @Override
    public boolean isExpanded(TreePath path) {
        if (path != null) {
            TreeStateNode lastNode = this.getNodeForPath(path, true, false);
            return lastNode != null && lastNode.isExpanded();
        }
        return false;
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        if (e != null) {
            int[] changedIndexs = e.getChildIndices();
            TreeStateNode changedNode = this.getNodeForPath(SwingUtilities2.getTreePath(e, this.getModel()), false, false);
            if (changedNode != null) {
                int aRow;
                Object changedValue = changedNode.getValue();
                changedNode.updatePreferredSize();
                if (changedNode.hasBeenExpanded() && changedIndexs != null) {
                    for (int counter = 0; counter < changedIndexs.length; ++counter) {
                        TreeStateNode changedChildNode = (TreeStateNode)changedNode.getChildAt(changedIndexs[counter]);
                        changedChildNode.setUserObject(this.treeModel.getChild(changedValue, changedIndexs[counter]));
                        changedChildNode.updatePreferredSize();
                    }
                } else if (changedNode == this.root) {
                    changedNode.updatePreferredSize();
                }
                if (!this.isFixedRowHeight() && (aRow = changedNode.getRow()) != -1) {
                    this.updateYLocationsFrom(aRow);
                }
                this.visibleNodesChanged();
            }
        }
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        if (e != null) {
            int[] changedIndexs = e.getChildIndices();
            TreeStateNode changedParentNode = this.getNodeForPath(SwingUtilities2.getTreePath(e, this.getModel()), false, false);
            if (changedParentNode != null && changedIndexs != null && changedIndexs.length > 0) {
                if (changedParentNode.hasBeenExpanded()) {
                    int oldChildCount = changedParentNode.getChildCount();
                    Object changedParent = changedParentNode.getValue();
                    boolean makeVisible = changedParentNode == this.root && !this.rootVisible || changedParentNode.getRow() != -1 && changedParentNode.isExpanded();
                    for (int counter = 0; counter < changedIndexs.length; ++counter) {
                        TreeStateNode newNode = this.createNodeAt(changedParentNode, changedIndexs[counter]);
                    }
                    if (oldChildCount == 0) {
                        changedParentNode.updatePreferredSize();
                    }
                    if (this.treeSelectionModel != null) {
                        this.treeSelectionModel.resetRowSelection();
                    }
                    if (!this.isFixedRowHeight() && (makeVisible || oldChildCount == 0 && changedParentNode.isVisible())) {
                        if (changedParentNode == this.root) {
                            this.updateYLocationsFrom(0);
                        } else {
                            this.updateYLocationsFrom(changedParentNode.getRow());
                        }
                        this.visibleNodesChanged();
                    } else if (makeVisible) {
                        this.visibleNodesChanged();
                    }
                } else if (this.treeModel.getChildCount(changedParentNode.getValue()) - changedIndexs.length == 0) {
                    changedParentNode.updatePreferredSize();
                    if (!this.isFixedRowHeight() && changedParentNode.isVisible()) {
                        this.updateYLocationsFrom(changedParentNode.getRow());
                    }
                }
            }
        }
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        if (e != null) {
            int[] changedIndexs = e.getChildIndices();
            TreeStateNode changedParentNode = this.getNodeForPath(SwingUtilities2.getTreePath(e, this.getModel()), false, false);
            if (changedParentNode != null && changedIndexs != null && changedIndexs.length > 0) {
                if (changedParentNode.hasBeenExpanded()) {
                    boolean makeInvisible = changedParentNode == this.root && !this.rootVisible || changedParentNode.getRow() != -1 && changedParentNode.isExpanded();
                    for (int counter = changedIndexs.length - 1; counter >= 0; --counter) {
                        int removedRow;
                        TreeStateNode removedNode = (TreeStateNode)changedParentNode.getChildAt(changedIndexs[counter]);
                        if (removedNode.isExpanded()) {
                            removedNode.collapse(false);
                        }
                        if (makeInvisible && (removedRow = removedNode.getRow()) != -1) {
                            this.visibleNodes.removeElementAt(removedRow);
                        }
                        changedParentNode.remove(changedIndexs[counter]);
                    }
                    if (changedParentNode.getChildCount() == 0) {
                        changedParentNode.updatePreferredSize();
                        if (changedParentNode.isExpanded() && changedParentNode.isLeaf()) {
                            changedParentNode.collapse(false);
                        }
                    }
                    if (this.treeSelectionModel != null) {
                        this.treeSelectionModel.resetRowSelection();
                    }
                    if (!this.isFixedRowHeight() && (makeInvisible || changedParentNode.getChildCount() == 0 && changedParentNode.isVisible())) {
                        if (changedParentNode == this.root) {
                            if (this.getRowCount() > 0) {
                                this.getNode(0).setYOrigin(0);
                            }
                            this.updateYLocationsFrom(0);
                        } else {
                            this.updateYLocationsFrom(changedParentNode.getRow());
                        }
                        this.visibleNodesChanged();
                    } else if (makeInvisible) {
                        this.visibleNodesChanged();
                    }
                } else if (this.treeModel.getChildCount(changedParentNode.getValue()) == 0) {
                    changedParentNode.updatePreferredSize();
                    if (!this.isFixedRowHeight() && changedParentNode.isVisible()) {
                        this.updateYLocationsFrom(changedParentNode.getRow());
                    }
                }
            }
        }
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        if (e != null) {
            TreePath changedPath = SwingUtilities2.getTreePath(e, this.getModel());
            TreeStateNode changedNode = this.getNodeForPath(changedPath, false, false);
            if (changedNode == this.root || changedNode == null && (changedPath == null && this.treeModel != null && this.treeModel.getRoot() == null || changedPath != null && changedPath.getPathCount() == 1)) {
                this.rebuild(true);
            } else if (changedNode != null) {
                boolean wasExpanded = changedNode.isExpanded();
                boolean wasVisible = changedNode.getRow() != -1;
                TreeStateNode parent = (TreeStateNode)changedNode.getParent();
                int nodeIndex = parent.getIndex(changedNode);
                if (wasVisible && wasExpanded) {
                    changedNode.collapse(false);
                }
                if (wasVisible) {
                    this.visibleNodes.removeElement(changedNode);
                }
                changedNode.removeFromParent();
                this.createNodeAt(parent, nodeIndex);
                TreeStateNode newNode = (TreeStateNode)parent.getChildAt(nodeIndex);
                if (wasVisible && wasExpanded) {
                    newNode.expand(false);
                }
                int newIndex = newNode.getRow();
                if (!this.isFixedRowHeight() && wasVisible) {
                    if (newIndex == 0) {
                        this.updateYLocationsFrom(newIndex);
                    } else {
                        this.updateYLocationsFrom(newIndex - 1);
                    }
                    this.visibleNodesChanged();
                } else if (wasVisible) {
                    this.visibleNodesChanged();
                }
            }
        }
    }

    private void visibleNodesChanged() {
    }

    private void addMapping(TreeStateNode node) {
        this.treePathMapping.put(node.getTreePath(), node);
    }

    private void removeMapping(TreeStateNode node) {
        this.treePathMapping.remove(node.getTreePath());
    }

    private TreeStateNode getMapping(TreePath path) {
        return this.treePathMapping.get(path);
    }

    private Rectangle getBounds(int row, Rectangle placeIn) {
        if (this.updateNodeSizes) {
            this.updateNodeSizes(false);
        }
        if (row >= 0 && row < this.getRowCount()) {
            return this.getNode(row).getNodeBounds(placeIn);
        }
        return null;
    }

    private void rebuild(boolean clearSelection) {
        Object rootObject;
        this.treePathMapping.clear();
        if (this.treeModel != null && (rootObject = this.treeModel.getRoot()) != null) {
            this.root = this.createNodeForValue(rootObject);
            this.root.path = new TreePath(rootObject);
            this.addMapping(this.root);
            this.root.updatePreferredSize(0);
            this.visibleNodes.removeAllElements();
            if (this.isRootVisible()) {
                this.visibleNodes.addElement(this.root);
            }
            if (!this.root.isExpanded()) {
                this.root.expand();
            } else {
                Enumeration cursor = this.root.children();
                while (cursor.hasMoreElements()) {
                    this.visibleNodes.addElement(cursor.nextElement());
                }
                if (!this.isFixedRowHeight()) {
                    this.updateYLocationsFrom(0);
                }
            }
        } else {
            this.visibleNodes.removeAllElements();
            this.root = null;
        }
        if (clearSelection && this.treeSelectionModel != null) {
            this.treeSelectionModel.clearSelection();
        }
        this.visibleNodesChanged();
    }

    private TreeStateNode createNodeAt(TreeStateNode parent, int childIndex) {
        boolean isParentRoot;
        Object newValue = this.treeModel.getChild(parent.getValue(), childIndex);
        TreeStateNode newChildNode = this.createNodeForValue(newValue);
        parent.insert(newChildNode, childIndex);
        newChildNode.updatePreferredSize(-1);
        boolean bl = isParentRoot = parent == this.root;
        if (newChildNode != null && parent.isExpanded() && (parent.getRow() != -1 || isParentRoot)) {
            int newRow;
            if (childIndex == 0) {
                newRow = isParentRoot && !this.isRootVisible() ? 0 : parent.getRow() + 1;
            } else if (childIndex == parent.getChildCount()) {
                newRow = parent.getLastVisibleNode().getRow() + 1;
            } else {
                TreeStateNode previousNode = (TreeStateNode)parent.getChildAt(childIndex - 1);
                newRow = previousNode.getLastVisibleNode().getRow() + 1;
            }
            this.visibleNodes.insertElementAt(newChildNode, newRow);
        }
        return newChildNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeStateNode getNodeForPath(TreePath path, boolean onlyIfVisible, boolean shouldCreate) {
        if (path != null) {
            TreeStateNode node = this.getMapping(path);
            if (node != null) {
                if (onlyIfVisible && !node.isVisible()) {
                    return null;
                }
                return node;
            }
            Stack<Object> paths = this.tempStacks.size() == 0 ? new Stack() : this.tempStacks.pop();
            try {
                paths.push(path);
                node = null;
                for (path = path.getParentPath(); path != null; path = path.getParentPath()) {
                    node = this.getMapping(path);
                    if (node != null) {
                        while (node != null && paths.size() > 0) {
                            path = (TreePath)paths.pop();
                            node.getLoadedChildren(shouldCreate);
                            int childIndex = this.treeModel.getIndexOfChild(node.getUserObject(), path.getLastPathComponent());
                            if (childIndex == -1 || childIndex >= node.getChildCount() || onlyIfVisible && !node.isVisible()) {
                                node = null;
                                continue;
                            }
                            node = (TreeStateNode)node.getChildAt(childIndex);
                        }
                        TreeStateNode treeStateNode = node;
                        return treeStateNode;
                    }
                    paths.push(path);
                }
            }
            finally {
                paths.removeAllElements();
                this.tempStacks.push(paths);
            }
        }
        return null;
    }

    private void updateYLocationsFrom(int location) {
        if (location >= 0 && location < this.getRowCount()) {
            TreeStateNode aNode = this.getNode(location);
            int newYOrigin = aNode.getYOrigin() + aNode.getPreferredHeight();
            int maxCounter = this.visibleNodes.size();
            for (int counter = location + 1; counter < maxCounter; ++counter) {
                aNode = (TreeStateNode)this.visibleNodes.elementAt(counter);
                aNode.setYOrigin(newYOrigin);
                newYOrigin += aNode.getPreferredHeight();
            }
        }
    }

    private void updateNodeSizes(boolean updateAll) {
        this.updateNodeSizes = false;
        int aY = 0;
        int maxCounter = this.visibleNodes.size();
        for (int counter = 0; counter < maxCounter; ++counter) {
            TreeStateNode node = (TreeStateNode)this.visibleNodes.elementAt(counter);
            node.setYOrigin(aY);
            if (updateAll || !node.hasValidSize()) {
                node.updatePreferredSize(counter);
            }
            aY += node.getPreferredHeight();
        }
    }

    private int getRowContainingYLocation(int location) {
        if (this.isFixedRowHeight()) {
            if (this.getRowCount() == 0) {
                return -1;
            }
            return Math.max(0, Math.min(this.getRowCount() - 1, location / this.getRowHeight()));
        }
        int max = this.getRowCount();
        if (max <= 0) {
            return -1;
        }
        int min = 0;
        int mid = 0;
        while (min < max) {
            mid = (max - min) / 2 + min;
            TreeStateNode node = (TreeStateNode)this.visibleNodes.elementAt(mid);
            int minY = node.getYOrigin();
            int maxY = minY + node.getPreferredHeight();
            if (location < minY) {
                max = mid - 1;
                continue;
            }
            if (location < maxY) break;
            min = mid + 1;
        }
        if (min == max && (mid = min) >= this.getRowCount()) {
            mid = this.getRowCount() - 1;
        }
        return mid;
    }

    private void ensurePathIsExpanded(TreePath aPath, boolean expandLast) {
        if (aPath != null) {
            TreeStateNode lastNode;
            if (this.treeModel.isLeaf(aPath.getLastPathComponent())) {
                aPath = aPath.getParentPath();
                expandLast = true;
            }
            if (aPath != null && (lastNode = this.getNodeForPath(aPath, false, true)) != null) {
                lastNode.makeVisible();
                if (expandLast) {
                    lastNode.expand();
                }
            }
        }
    }

    private TreeStateNode getNode(int row) {
        return (TreeStateNode)this.visibleNodes.elementAt(row);
    }

    private int getMaxNodeWidth() {
        int maxWidth = 0;
        for (int counter = this.getRowCount() - 1; counter >= 0; --counter) {
            TreeStateNode node = this.getNode(counter);
            int nodeWidth = node.getPreferredWidth() + node.getXOrigin();
            if (nodeWidth <= maxWidth) continue;
            maxWidth = nodeWidth;
        }
        return maxWidth;
    }

    private TreeStateNode createNodeForValue(Object value) {
        return new TreeStateNode(value);
    }

    private class VisibleTreeStateNodeEnumeration
    implements Enumeration<TreePath> {
        protected TreeStateNode parent;
        protected int nextIndex;
        protected int childCount;

        protected VisibleTreeStateNodeEnumeration(TreeStateNode node) {
            this(node, -1);
        }

        protected VisibleTreeStateNodeEnumeration(TreeStateNode parent, int startIndex) {
            this.parent = parent;
            this.nextIndex = startIndex;
            this.childCount = this.parent.getChildCount();
        }

        @Override
        public boolean hasMoreElements() {
            return this.parent != null;
        }

        @Override
        public TreePath nextElement() {
            TreePath retObject;
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException("No more visible paths");
            }
            if (this.nextIndex == -1) {
                retObject = this.parent.getTreePath();
            } else {
                TreeStateNode node = (TreeStateNode)this.parent.getChildAt(this.nextIndex);
                retObject = node.getTreePath();
            }
            this.updateNextObject();
            return retObject;
        }

        protected void updateNextObject() {
            if (!this.updateNextIndex()) {
                this.findNextValidParent();
            }
        }

        protected boolean findNextValidParent() {
            if (this.parent == VariableHeightLayoutCache.this.root) {
                this.parent = null;
                return false;
            }
            while (this.parent != null) {
                TreeStateNode newParent = (TreeStateNode)this.parent.getParent();
                if (newParent != null) {
                    this.nextIndex = newParent.getIndex(this.parent);
                    this.parent = newParent;
                    this.childCount = this.parent.getChildCount();
                    if (!this.updateNextIndex()) continue;
                    return true;
                }
                this.parent = null;
            }
            return false;
        }

        protected boolean updateNextIndex() {
            if (this.nextIndex == -1 && !this.parent.isExpanded()) {
                return false;
            }
            if (this.childCount == 0) {
                return false;
            }
            if (++this.nextIndex >= this.childCount) {
                return false;
            }
            TreeStateNode child = (TreeStateNode)this.parent.getChildAt(this.nextIndex);
            if (child != null && child.isExpanded()) {
                this.parent = child;
                this.nextIndex = -1;
                this.childCount = child.getChildCount();
            }
            return true;
        }
    }

    private class TreeStateNode
    extends DefaultMutableTreeNode {
        protected int preferredWidth;
        protected int preferredHeight;
        protected int xOrigin;
        protected int yOrigin;
        protected boolean expanded;
        protected boolean hasBeenExpanded;
        protected TreePath path;

        public TreeStateNode(Object value) {
            super(value);
        }

        @Override
        public void setParent(MutableTreeNode parent) {
            super.setParent(parent);
            if (parent != null) {
                this.path = ((TreeStateNode)parent).getTreePath().pathByAddingChild(this.getUserObject());
                VariableHeightLayoutCache.this.addMapping(this);
            }
        }

        @Override
        public void remove(int childIndex) {
            TreeStateNode node = (TreeStateNode)this.getChildAt(childIndex);
            node.removeFromMapping();
            super.remove(childIndex);
        }

        @Override
        public void setUserObject(Object o) {
            super.setUserObject(o);
            if (this.path != null) {
                TreeStateNode parent = (TreeStateNode)this.getParent();
                if (parent != null) {
                    this.resetChildrenPaths(parent.getTreePath());
                } else {
                    this.resetChildrenPaths(null);
                }
            }
        }

        @Override
        public Enumeration children() {
            if (!this.isExpanded()) {
                return DefaultMutableTreeNode.EMPTY_ENUMERATION;
            }
            return super.children();
        }

        @Override
        public boolean isLeaf() {
            return VariableHeightLayoutCache.this.getModel().isLeaf(this.getValue());
        }

        public Rectangle getNodeBounds(Rectangle placeIn) {
            if (placeIn == null) {
                placeIn = new Rectangle(this.getXOrigin(), this.getYOrigin(), this.getPreferredWidth(), this.getPreferredHeight());
            } else {
                placeIn.x = this.getXOrigin();
                placeIn.y = this.getYOrigin();
                placeIn.width = this.getPreferredWidth();
                placeIn.height = this.getPreferredHeight();
            }
            return placeIn;
        }

        public int getXOrigin() {
            if (!this.hasValidSize()) {
                this.updatePreferredSize(this.getRow());
            }
            return this.xOrigin;
        }

        public int getYOrigin() {
            if (VariableHeightLayoutCache.this.isFixedRowHeight()) {
                int aRow = this.getRow();
                if (aRow == -1) {
                    return -1;
                }
                return VariableHeightLayoutCache.this.getRowHeight() * aRow;
            }
            return this.yOrigin;
        }

        public int getPreferredHeight() {
            if (VariableHeightLayoutCache.this.isFixedRowHeight()) {
                return VariableHeightLayoutCache.this.getRowHeight();
            }
            if (!this.hasValidSize()) {
                this.updatePreferredSize(this.getRow());
            }
            return this.preferredHeight;
        }

        public int getPreferredWidth() {
            if (!this.hasValidSize()) {
                this.updatePreferredSize(this.getRow());
            }
            return this.preferredWidth;
        }

        public boolean hasValidSize() {
            return this.preferredHeight != 0;
        }

        public int getRow() {
            return VariableHeightLayoutCache.this.visibleNodes.indexOf(this);
        }

        public boolean hasBeenExpanded() {
            return this.hasBeenExpanded;
        }

        public boolean isExpanded() {
            return this.expanded;
        }

        public TreeStateNode getLastVisibleNode() {
            TreeStateNode node = this;
            while (node.isExpanded() && node.getChildCount() > 0) {
                node = (TreeStateNode)node.getLastChild();
            }
            return node;
        }

        public boolean isVisible() {
            if (this == VariableHeightLayoutCache.this.root) {
                return true;
            }
            TreeStateNode parent = (TreeStateNode)this.getParent();
            return parent != null && parent.isExpanded() && parent.isVisible();
        }

        public int getModelChildCount() {
            if (this.hasBeenExpanded) {
                return super.getChildCount();
            }
            return VariableHeightLayoutCache.this.getModel().getChildCount(this.getValue());
        }

        public int getVisibleChildCount() {
            int childCount = 0;
            if (this.isExpanded()) {
                int maxCounter = this.getChildCount();
                childCount += maxCounter;
                for (int counter = 0; counter < maxCounter; ++counter) {
                    childCount += ((TreeStateNode)this.getChildAt(counter)).getVisibleChildCount();
                }
            }
            return childCount;
        }

        public void toggleExpanded() {
            if (this.isExpanded()) {
                this.collapse();
            } else {
                this.expand();
            }
        }

        public void makeVisible() {
            TreeStateNode parent = (TreeStateNode)this.getParent();
            if (parent != null) {
                parent.expandParentAndReceiver();
            }
        }

        public void expand() {
            this.expand(true);
        }

        public void collapse() {
            this.collapse(true);
        }

        public Object getValue() {
            return this.getUserObject();
        }

        public TreePath getTreePath() {
            return this.path;
        }

        protected void resetChildrenPaths(TreePath parentPath) {
            VariableHeightLayoutCache.this.removeMapping(this);
            this.path = parentPath == null ? new TreePath(this.getUserObject()) : parentPath.pathByAddingChild(this.getUserObject());
            VariableHeightLayoutCache.this.addMapping(this);
            for (int counter = this.getChildCount() - 1; counter >= 0; --counter) {
                ((TreeStateNode)this.getChildAt(counter)).resetChildrenPaths(this.path);
            }
        }

        protected void setYOrigin(int newYOrigin) {
            this.yOrigin = newYOrigin;
        }

        protected void shiftYOriginBy(int offset) {
            this.yOrigin += offset;
        }

        protected void updatePreferredSize() {
            this.updatePreferredSize(this.getRow());
        }

        protected void updatePreferredSize(int index) {
            Rectangle bounds = VariableHeightLayoutCache.this.getNodeDimensions(this.getUserObject(), index, this.getLevel(), this.isExpanded(), VariableHeightLayoutCache.this.boundsBuffer);
            if (bounds == null) {
                this.xOrigin = 0;
                this.preferredHeight = 0;
                this.preferredWidth = 0;
                VariableHeightLayoutCache.this.updateNodeSizes = true;
            } else if (bounds.height == 0) {
                this.xOrigin = 0;
                this.preferredHeight = 0;
                this.preferredWidth = 0;
                VariableHeightLayoutCache.this.updateNodeSizes = true;
            } else {
                this.xOrigin = bounds.x;
                this.preferredWidth = bounds.width;
                this.preferredHeight = VariableHeightLayoutCache.this.isFixedRowHeight() ? VariableHeightLayoutCache.this.getRowHeight() : bounds.height;
            }
        }

        protected void markSizeInvalid() {
            this.preferredHeight = 0;
        }

        protected void deepMarkSizeInvalid() {
            this.markSizeInvalid();
            for (int counter = this.getChildCount() - 1; counter >= 0; --counter) {
                ((TreeStateNode)this.getChildAt(counter)).deepMarkSizeInvalid();
            }
        }

        protected Enumeration getLoadedChildren(boolean createIfNeeded) {
            if (!createIfNeeded || this.hasBeenExpanded) {
                return super.children();
            }
            Object realNode = this.getValue();
            TreeModel treeModel = VariableHeightLayoutCache.this.getModel();
            int count = treeModel.getChildCount(realNode);
            this.hasBeenExpanded = true;
            int childRow = this.getRow();
            if (childRow == -1) {
                for (int i = 0; i < count; ++i) {
                    TreeStateNode newNode = VariableHeightLayoutCache.this.createNodeForValue(treeModel.getChild(realNode, i));
                    this.add(newNode);
                    newNode.updatePreferredSize(-1);
                }
            } else {
                ++childRow;
                for (int i = 0; i < count; ++i) {
                    TreeStateNode newNode = VariableHeightLayoutCache.this.createNodeForValue(treeModel.getChild(realNode, i));
                    this.add(newNode);
                    newNode.updatePreferredSize(childRow++);
                }
            }
            return super.children();
        }

        protected void didAdjustTree() {
        }

        protected void expandParentAndReceiver() {
            TreeStateNode parent = (TreeStateNode)this.getParent();
            if (parent != null) {
                parent.expandParentAndReceiver();
            }
            this.expand();
        }

        protected void expand(boolean adjustTree) {
            if (!this.isExpanded() && !this.isLeaf()) {
                boolean isFixed = VariableHeightLayoutCache.this.isFixedRowHeight();
                int startHeight = this.getPreferredHeight();
                int originalRow = this.getRow();
                this.expanded = true;
                this.updatePreferredSize(originalRow);
                if (!this.hasBeenExpanded) {
                    TreeStateNode newNode;
                    Object realNode = this.getValue();
                    TreeModel treeModel = VariableHeightLayoutCache.this.getModel();
                    int count = treeModel.getChildCount(realNode);
                    this.hasBeenExpanded = true;
                    if (originalRow == -1) {
                        for (int i = 0; i < count; ++i) {
                            newNode = VariableHeightLayoutCache.this.createNodeForValue(treeModel.getChild(realNode, i));
                            this.add(newNode);
                            newNode.updatePreferredSize(-1);
                        }
                    } else {
                        int offset = originalRow + 1;
                        for (int i = 0; i < count; ++i) {
                            newNode = VariableHeightLayoutCache.this.createNodeForValue(treeModel.getChild(realNode, i));
                            this.add(newNode);
                            newNode.updatePreferredSize(offset);
                        }
                    }
                }
                int i = originalRow;
                Enumeration cursor = this.preorderEnumeration();
                cursor.nextElement();
                int newYOrigin = isFixed ? 0 : (this == VariableHeightLayoutCache.this.root && !VariableHeightLayoutCache.this.isRootVisible() ? 0 : this.getYOrigin() + this.getPreferredHeight());
                if (!isFixed) {
                    while (cursor.hasMoreElements()) {
                        TreeStateNode aNode = (TreeStateNode)cursor.nextElement();
                        if (!VariableHeightLayoutCache.this.updateNodeSizes && !aNode.hasValidSize()) {
                            aNode.updatePreferredSize(i + 1);
                        }
                        aNode.setYOrigin(newYOrigin);
                        newYOrigin += aNode.getPreferredHeight();
                        VariableHeightLayoutCache.this.visibleNodes.insertElementAt(aNode, ++i);
                    }
                } else {
                    while (cursor.hasMoreElements()) {
                        TreeStateNode aNode = (TreeStateNode)cursor.nextElement();
                        VariableHeightLayoutCache.this.visibleNodes.insertElementAt(aNode, ++i);
                    }
                }
                if (adjustTree && (originalRow != i || this.getPreferredHeight() != startHeight)) {
                    if (!isFixed && ++i < VariableHeightLayoutCache.this.getRowCount()) {
                        int heightDiff = newYOrigin - (this.getYOrigin() + this.getPreferredHeight()) + (this.getPreferredHeight() - startHeight);
                        for (int counter = VariableHeightLayoutCache.this.visibleNodes.size() - 1; counter >= i; --counter) {
                            ((TreeStateNode)VariableHeightLayoutCache.this.visibleNodes.elementAt(counter)).shiftYOriginBy(heightDiff);
                        }
                    }
                    this.didAdjustTree();
                    VariableHeightLayoutCache.this.visibleNodesChanged();
                }
                if (VariableHeightLayoutCache.this.treeSelectionModel != null) {
                    VariableHeightLayoutCache.this.treeSelectionModel.resetRowSelection();
                }
            }
        }

        protected void collapse(boolean adjustTree) {
            if (this.isExpanded()) {
                int counter;
                TreeStateNode node;
                Enumeration cursor = this.preorderEnumeration();
                cursor.nextElement();
                int rowsDeleted = 0;
                boolean isFixed = VariableHeightLayoutCache.this.isFixedRowHeight();
                int lastYEnd = isFixed ? 0 : this.getPreferredHeight() + this.getYOrigin();
                int startHeight = this.getPreferredHeight();
                int startYEnd = lastYEnd;
                int myRow = this.getRow();
                if (!isFixed) {
                    while (cursor.hasMoreElements()) {
                        node = (TreeStateNode)cursor.nextElement();
                        if (!node.isVisible()) continue;
                        ++rowsDeleted;
                        lastYEnd = node.getYOrigin() + node.getPreferredHeight();
                    }
                } else {
                    while (cursor.hasMoreElements()) {
                        node = (TreeStateNode)cursor.nextElement();
                        if (!node.isVisible()) continue;
                        ++rowsDeleted;
                    }
                }
                for (counter = rowsDeleted + myRow; counter > myRow; --counter) {
                    VariableHeightLayoutCache.this.visibleNodes.removeElementAt(counter);
                }
                this.expanded = false;
                if (myRow == -1) {
                    this.markSizeInvalid();
                } else if (adjustTree) {
                    this.updatePreferredSize(myRow);
                }
                if (myRow != -1 && adjustTree && (rowsDeleted > 0 || startHeight != this.getPreferredHeight())) {
                    if (!isFixed && myRow + 1 < VariableHeightLayoutCache.this.getRowCount() && (startYEnd += this.getPreferredHeight() - startHeight) != lastYEnd) {
                        int shiftAmount = startYEnd - lastYEnd;
                        int maxCounter = VariableHeightLayoutCache.this.visibleNodes.size();
                        for (counter = myRow + 1; counter < maxCounter; ++counter) {
                            ((TreeStateNode)VariableHeightLayoutCache.this.visibleNodes.elementAt(counter)).shiftYOriginBy(shiftAmount);
                        }
                    }
                    this.didAdjustTree();
                    VariableHeightLayoutCache.this.visibleNodesChanged();
                }
                if (VariableHeightLayoutCache.this.treeSelectionModel != null && rowsDeleted > 0 && myRow != -1) {
                    VariableHeightLayoutCache.this.treeSelectionModel.resetRowSelection();
                }
            }
        }

        protected void removeFromMapping() {
            if (this.path != null) {
                VariableHeightLayoutCache.this.removeMapping(this);
                for (int counter = this.getChildCount() - 1; counter >= 0; --counter) {
                    ((TreeStateNode)this.getChildAt(counter)).removeFromMapping();
                }
            }
        }
    }
}

