/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.peer.DialogPeer;
import java.util.List;
import sun.awt.AWTAccessor;
import sun.awt.im.InputMethodManager;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WWindowPeer;

final class WDialogPeer
extends WWindowPeer
implements DialogPeer {
    static final Color defaultBackground = SystemColor.control;
    boolean needDefaultBackground;

    WDialogPeer(Dialog target) {
        super(target);
        InputMethodManager imm = InputMethodManager.getInstance();
        String menuString = imm.getTriggerMenuString();
        if (menuString != null) {
            this.pSetIMMOption(menuString);
        }
    }

    native void createAwtDialog(WComponentPeer var1);

    @Override
    void create(WComponentPeer parent) {
        this.preCreate(parent);
        this.createAwtDialog(parent);
    }

    native void showModal();

    native void endModal();

    @Override
    void initialize() {
        Dialog target = (Dialog)this.target;
        if (this.needDefaultBackground) {
            target.setBackground(defaultBackground);
        }
        super.initialize();
        if (target.getTitle() != null) {
            this.setTitle(target.getTitle());
        }
        this.setResizable(target.isResizable());
    }

    @Override
    protected void realShow() {
        Dialog dlg = (Dialog)this.target;
        if (dlg.getModalityType() != Dialog.ModalityType.MODELESS) {
            this.showModal();
        } else {
            super.realShow();
        }
    }

    @Override
    void hide() {
        Dialog dlg = (Dialog)this.target;
        if (dlg.getModalityType() != Dialog.ModalityType.MODELESS) {
            this.endModal();
        } else {
            super.hide();
        }
    }

    @Override
    public void blockWindows(List<Window> toBlock) {
        for (Window w : toBlock) {
            WWindowPeer wp = (WWindowPeer)AWTAccessor.getComponentAccessor().getPeer(w);
            if (wp == null) continue;
            wp.setModalBlocked((Dialog)this.target, true);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        if (((Dialog)this.target).isUndecorated()) {
            return super.getMinimumSize();
        }
        return new Dimension(WDialogPeer.getSysMinWidth(), WDialogPeer.getSysMinHeight());
    }

    @Override
    boolean isTargetUndecorated() {
        return ((Dialog)this.target).isUndecorated();
    }

    @Override
    public void reshape(int x, int y, int width, int height) {
        if (((Dialog)this.target).isUndecorated()) {
            super.reshape(x, y, width, height);
        } else {
            this.reshapeFrame(x, y, width, height);
        }
    }

    private void setDefaultColor() {
        this.needDefaultBackground = true;
    }

    native void pSetIMMOption(String var1);

    void notifyIMMOptionChange() {
        InputMethodManager.getInstance().notifyChangeRequest((Component)this.target);
    }
}

