/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.peer.ComponentPeer;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FilePermission;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.PrinterResolution;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import sun.awt.Win32FontManager;
import sun.awt.windows.WPageDialog;
import sun.awt.windows.WPathGraphics;
import sun.awt.windows.WPrintDialog;
import sun.awt.windows.WWindowPeer;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;
import sun.java2d.DisposerTarget;
import sun.print.DialogOwner;
import sun.print.PeekGraphics;
import sun.print.PeekMetrics;
import sun.print.RasterPrinterJob;
import sun.print.ServiceDialog;
import sun.print.SunAlternateMedia;
import sun.print.SunPageSelection;
import sun.print.Win32MediaTray;
import sun.print.Win32PrintService;
import sun.print.Win32PrintServiceLookup;

public final class WPrinterJob
extends RasterPrinterJob
implements DisposerTarget {
    protected static final long PS_ENDCAP_ROUND = 0L;
    protected static final long PS_ENDCAP_SQUARE = 256L;
    protected static final long PS_ENDCAP_FLAT = 512L;
    protected static final long PS_JOIN_ROUND = 0L;
    protected static final long PS_JOIN_BEVEL = 4096L;
    protected static final long PS_JOIN_MITER = 8192L;
    protected static final int POLYFILL_ALTERNATE = 1;
    protected static final int POLYFILL_WINDING = 2;
    private static final int MAX_WCOLOR = 255;
    private static final int SET_DUP_VERTICAL = 16;
    private static final int SET_DUP_HORIZONTAL = 32;
    private static final int SET_RES_HIGH = 64;
    private static final int SET_RES_LOW = 128;
    private static final int SET_COLOR = 512;
    private static final int SET_ORIENTATION = 16384;
    private static final int SET_COLLATED = 32768;
    private static final int PD_COLLATE = 16;
    private static final int PD_PRINTTOFILE = 32;
    private static final int DM_ORIENTATION = 1;
    private static final int DM_PAPERSIZE = 2;
    private static final int DM_COPIES = 256;
    private static final int DM_DEFAULTSOURCE = 512;
    private static final int DM_PRINTQUALITY = 1024;
    private static final int DM_COLOR = 2048;
    private static final int DM_DUPLEX = 4096;
    private static final int DM_YRESOLUTION = 8192;
    private static final int DM_COLLATE = 32768;
    private static final short DMCOLLATE_FALSE = 0;
    private static final short DMCOLLATE_TRUE = 1;
    private static final short DMORIENT_PORTRAIT = 1;
    private static final short DMORIENT_LANDSCAPE = 2;
    private static final short DMCOLOR_MONOCHROME = 1;
    private static final short DMCOLOR_COLOR = 2;
    private static final short DMRES_DRAFT = -1;
    private static final short DMRES_LOW = -2;
    private static final short DMRES_MEDIUM = -3;
    private static final short DMRES_HIGH = -4;
    private static final short DMDUP_SIMPLEX = 1;
    private static final short DMDUP_VERTICAL = 2;
    private static final short DMDUP_HORIZONTAL = 3;
    private static final int MAX_UNKNOWN_PAGES = 9999;
    private boolean driverDoesMultipleCopies = false;
    private boolean driverDoesCollation = false;
    private boolean userRequestedCollation = false;
    private boolean noDefaultPrinter = false;
    private HandleRecord handleRecord = new HandleRecord();
    private int mPrintPaperSize;
    private int mPrintXRes;
    private int mPrintYRes;
    private int mPrintPhysX;
    private int mPrintPhysY;
    private int mPrintWidth;
    private int mPrintHeight;
    private int mPageWidth;
    private int mPageHeight;
    private int mAttSides;
    private int mAttChromaticity;
    private int mAttXRes;
    private int mAttYRes;
    private int mAttQuality;
    private int mAttCollate;
    private int mAttCopies;
    private int mAttMediaSizeName;
    private int mAttMediaTray;
    private String mDestination = null;
    private Color mLastColor;
    private Color mLastTextColor;
    private String mLastFontFamily;
    private float mLastFontSize;
    private int mLastFontStyle;
    private int mLastRotation;
    private float mLastAwScale;
    private PrinterJob pjob;
    private ComponentPeer dialogOwnerPeer = null;
    private Object disposerReferent = new Object();
    private String lastNativeService = null;
    private boolean defaultCopies = true;

    public WPrinterJob() {
        this.handleRecord = new HandleRecord();
        Disposer.addRecord(this.disposerReferent, this.handleRecord);
        this.initAttributeMembers();
    }

    @Override
    public Object getDisposerReferent() {
        return this.disposerReferent;
    }

    @Override
    public PageFormat pageDialog(PageFormat page) throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (!(this.getPrintService() instanceof Win32PrintService)) {
            return super.pageDialog(page);
        }
        PageFormat pageClone = (PageFormat)page.clone();
        boolean result = false;
        WPageDialog dialog = new WPageDialog((Frame)null, (PrinterJob)this, pageClone, null);
        dialog.setRetVal(false);
        dialog.setVisible(true);
        result = dialog.getRetVal();
        dialog.dispose();
        if (result && this.myService != null) {
            String printerName = this.getNativePrintService();
            if (!this.myService.getName().equals(printerName)) {
                try {
                    this.setPrintService(Win32PrintServiceLookup.getWin32PrintLUS().getPrintServiceByName(printerName));
                }
                catch (PrinterException printerException) {
                    // empty catch block
                }
            }
            this.updatePageAttributes(this.myService, pageClone);
            return pageClone;
        }
        return page;
    }

    private boolean displayNativeDialog() {
        String pathName;
        if (this.attributes == null) {
            return false;
        }
        DialogOwner dlgOwner = (DialogOwner)this.attributes.get(DialogOwner.class);
        Frame ownerFrame = dlgOwner != null ? dlgOwner.getOwner() : null;
        WPrintDialog dialog = new WPrintDialog(ownerFrame, (PrinterJob)this);
        dialog.setRetVal(false);
        dialog.setVisible(true);
        boolean prv = dialog.getRetVal();
        dialog.dispose();
        Destination dest = (Destination)this.attributes.get(Destination.class);
        if (dest == null || !prv) {
            return prv;
        }
        String title = null;
        String strBundle = "sun.print.resources.serviceui";
        ResourceBundle rb = ResourceBundle.getBundle(strBundle);
        try {
            title = rb.getString("dialog.printtofile");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        FileDialog fileDialog = new FileDialog(ownerFrame, title, 1);
        URI destURI = dest.getURI();
        String string = pathName = destURI != null ? destURI.getSchemeSpecificPart() : null;
        if (pathName != null) {
            File file = new File(pathName);
            fileDialog.setFile(file.getName());
            File parent = file.getParentFile();
            if (parent != null) {
                fileDialog.setDirectory(parent.getPath());
            }
        } else {
            fileDialog.setFile("out.prn");
        }
        fileDialog.setVisible(true);
        String fileName = fileDialog.getFile();
        if (fileName == null) {
            fileDialog.dispose();
            return false;
        }
        String fullName = fileDialog.getDirectory() + fileName;
        File f = new File(fullName);
        File pFile = f.getParentFile();
        while (f.exists() && (!f.isFile() || !f.canWrite()) || pFile != null && (!pFile.exists() || pFile.exists() && !pFile.canWrite())) {
            new PrintToFileErrorDialog(ownerFrame, ServiceDialog.getMsg("dialog.owtitle"), ServiceDialog.getMsg("dialog.writeerror") + " " + fullName, ServiceDialog.getMsg("button.ok")).setVisible(true);
            fileDialog.setVisible(true);
            fileName = fileDialog.getFile();
            if (fileName == null) {
                fileDialog.dispose();
                return false;
            }
            fullName = fileDialog.getDirectory() + fileName;
            f = new File(fullName);
            pFile = f.getParentFile();
        }
        fileDialog.dispose();
        this.attributes.add(new Destination(f.toURI()));
        return true;
    }

    @Override
    public boolean printDialog() throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (this.attributes == null) {
            this.attributes = new HashPrintRequestAttributeSet();
        }
        if (!(this.getPrintService() instanceof Win32PrintService)) {
            return super.printDialog(this.attributes);
        }
        if (this.noDefaultPrinter) {
            return false;
        }
        return this.displayNativeDialog();
    }

    @Override
    public void setPrintService(PrintService service) throws PrinterException {
        super.setPrintService(service);
        if (!(service instanceof Win32PrintService)) {
            return;
        }
        this.driverDoesMultipleCopies = false;
        this.driverDoesCollation = false;
        this.setNativePrintServiceIfNeeded(service.getName());
    }

    private native void setNativePrintService(String var1) throws PrinterException;

    private void setNativePrintServiceIfNeeded(String name) throws PrinterException {
        if (name != null && !name.equals(this.lastNativeService)) {
            this.setNativePrintService(name);
            this.lastNativeService = name;
        }
    }

    @Override
    public PrintService getPrintService() {
        if (this.myService == null) {
            String printerName = this.getNativePrintService();
            if (printerName != null) {
                this.myService = Win32PrintServiceLookup.getWin32PrintLUS().getPrintServiceByName(printerName);
                if (this.myService != null) {
                    return this.myService;
                }
            }
            this.myService = PrintServiceLookup.lookupDefaultPrintService();
            if (this.myService instanceof Win32PrintService) {
                try {
                    this.setNativePrintServiceIfNeeded(this.myService.getName());
                }
                catch (Exception e) {
                    this.myService = null;
                }
            }
        }
        return this.myService;
    }

    private native String getNativePrintService();

    private void initAttributeMembers() {
        this.mAttSides = 0;
        this.mAttChromaticity = 0;
        this.mAttXRes = 0;
        this.mAttYRes = 0;
        this.mAttQuality = 0;
        this.mAttCollate = -1;
        this.mAttCopies = 0;
        this.mAttMediaTray = 0;
        this.mAttMediaSizeName = 0;
        this.mDestination = null;
    }

    @Override
    protected void setAttributes(PrintRequestAttributeSet attributes) throws PrinterException {
        this.initAttributeMembers();
        super.setAttributes(attributes);
        this.mAttCopies = this.getCopiesInt();
        this.mDestination = this.destinationAttr;
        if (attributes == null) {
            return;
        }
        Attribute[] attrs = attributes.toArray();
        for (int i = 0; i < attrs.length; ++i) {
            Attribute attr = attrs[i];
            try {
                Media media;
                if (attr.getCategory() == Sides.class) {
                    this.setSidesAttrib(attr);
                    continue;
                }
                if (attr.getCategory() == Chromaticity.class) {
                    this.setColorAttrib(attr);
                    continue;
                }
                if (attr.getCategory() == PrinterResolution.class) {
                    this.setResolutionAttrib(attr);
                    continue;
                }
                if (attr.getCategory() == PrintQuality.class) {
                    this.setQualityAttrib(attr);
                    continue;
                }
                if (attr.getCategory() == SheetCollate.class) {
                    this.setCollateAttrib(attr);
                    continue;
                }
                if (attr.getCategory() != Media.class && attr.getCategory() != SunAlternateMedia.class) continue;
                if (!(attr.getCategory() != SunAlternateMedia.class || (media = (Media)attributes.get(Media.class)) != null && media instanceof MediaTray)) {
                    attr = ((SunAlternateMedia)attr).getMedia();
                }
                if (attr instanceof MediaSizeName) {
                    this.setWin32MediaAttrib(attr);
                }
                if (!(attr instanceof MediaTray)) continue;
                this.setMediaTrayAttrib(attr);
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    private native void getDefaultPage(PageFormat var1);

    @Override
    public PageFormat defaultPage(PageFormat page) {
        PageFormat newPage = (PageFormat)page.clone();
        this.getDefaultPage(newPage);
        return newPage;
    }

    @Override
    protected native void validatePaper(Paper var1, Paper var2);

    @Override
    protected Graphics2D createPathGraphics(PeekGraphics peekGraphics, PrinterJob printerJob, Printable painter, PageFormat pageFormat, int pageIndex) {
        WPathGraphics pathGraphics;
        PeekMetrics metrics = peekGraphics.getMetrics();
        if (!forcePDL && (forceRaster || metrics.hasNonSolidColors() || metrics.hasCompositing())) {
            pathGraphics = null;
        } else {
            BufferedImage bufferedImage = new BufferedImage(8, 8, 1);
            Graphics2D bufferedGraphics = bufferedImage.createGraphics();
            boolean canRedraw = !peekGraphics.getAWTDrawingOnly();
            pathGraphics = new WPathGraphics(bufferedGraphics, printerJob, painter, pageFormat, pageIndex, canRedraw);
        }
        return pathGraphics;
    }

    @Override
    protected double getXRes() {
        if (this.mAttXRes != 0) {
            return this.mAttXRes;
        }
        return this.mPrintXRes;
    }

    @Override
    protected double getYRes() {
        if (this.mAttYRes != 0) {
            return this.mAttYRes;
        }
        return this.mPrintYRes;
    }

    @Override
    protected double getPhysicalPrintableX(Paper p) {
        return this.mPrintPhysX;
    }

    @Override
    protected double getPhysicalPrintableY(Paper p) {
        return this.mPrintPhysY;
    }

    @Override
    protected double getPhysicalPrintableWidth(Paper p) {
        return this.mPrintWidth;
    }

    @Override
    protected double getPhysicalPrintableHeight(Paper p) {
        return this.mPrintHeight;
    }

    @Override
    protected double getPhysicalPageWidth(Paper p) {
        return this.mPageWidth;
    }

    @Override
    protected double getPhysicalPageHeight(Paper p) {
        return this.mPageHeight;
    }

    @Override
    protected boolean isCollated() {
        return this.userRequestedCollation;
    }

    @Override
    protected int getCollatedCopies() {
        this.debug_println("driverDoesMultipleCopies=" + this.driverDoesMultipleCopies + " driverDoesCollation=" + this.driverDoesCollation);
        if (super.isCollated() && !this.driverDoesCollation) {
            this.mAttCollate = 0;
            this.mAttCopies = 1;
            return this.getCopies();
        }
        return 1;
    }

    @Override
    protected int getNoncollatedCopies() {
        if (this.driverDoesMultipleCopies || super.isCollated()) {
            return 1;
        }
        return this.getCopies();
    }

    private long getPrintDC() {
        return this.handleRecord.mPrintDC;
    }

    private void setPrintDC(long mPrintDC) {
        this.handleRecord.mPrintDC = mPrintDC;
    }

    private long getDevMode() {
        return this.handleRecord.mPrintHDevMode;
    }

    private void setDevMode(long mPrintHDevMode) {
        this.handleRecord.mPrintHDevMode = mPrintHDevMode;
    }

    private long getDevNames() {
        return this.handleRecord.mPrintHDevNames;
    }

    private void setDevNames(long mPrintHDevNames) {
        this.handleRecord.mPrintHDevNames = mPrintHDevNames;
    }

    protected void beginPath() {
        this.beginPath(this.getPrintDC());
    }

    protected void endPath() {
        this.endPath(this.getPrintDC());
    }

    protected void closeFigure() {
        this.closeFigure(this.getPrintDC());
    }

    protected void fillPath() {
        this.fillPath(this.getPrintDC());
    }

    protected void moveTo(float x, float y) {
        this.moveTo(this.getPrintDC(), x, y);
    }

    protected void lineTo(float x, float y) {
        this.lineTo(this.getPrintDC(), x, y);
    }

    protected void polyBezierTo(float control1x, float control1y, float control2x, float control2y, float endX, float endY) {
        this.polyBezierTo(this.getPrintDC(), control1x, control1y, control2x, control2y, endX, endY);
    }

    protected void setPolyFillMode(int fillRule) {
        this.setPolyFillMode(this.getPrintDC(), fillRule);
    }

    protected void selectSolidBrush(Color color) {
        if (!color.equals(this.mLastColor)) {
            this.mLastColor = color;
            float[] rgb = color.getRGBColorComponents(null);
            this.selectSolidBrush(this.getPrintDC(), (int)(rgb[0] * 255.0f), (int)(rgb[1] * 255.0f), (int)(rgb[2] * 255.0f));
        }
    }

    protected int getPenX() {
        return this.getPenX(this.getPrintDC());
    }

    protected int getPenY() {
        return this.getPenY(this.getPrintDC());
    }

    protected void selectClipPath() {
        this.selectClipPath(this.getPrintDC());
    }

    protected void frameRect(float x, float y, float width, float height) {
        this.frameRect(this.getPrintDC(), x, y, width, height);
    }

    protected void fillRect(float x, float y, float width, float height, Color color) {
        float[] rgb = color.getRGBColorComponents(null);
        this.fillRect(this.getPrintDC(), x, y, width, height, (int)(rgb[0] * 255.0f), (int)(rgb[1] * 255.0f), (int)(rgb[2] * 255.0f));
    }

    protected void selectPen(float width, Color color) {
        float[] rgb = color.getRGBColorComponents(null);
        this.selectPen(this.getPrintDC(), width, (int)(rgb[0] * 255.0f), (int)(rgb[1] * 255.0f), (int)(rgb[2] * 255.0f));
    }

    protected boolean selectStylePen(int cap, int join, float width, Color color) {
        long lineJoin;
        long endCap;
        float[] rgb = color.getRGBColorComponents(null);
        switch (cap) {
            case 0: {
                endCap = 512L;
                break;
            }
            case 1: {
                endCap = 0L;
                break;
            }
            default: {
                endCap = 256L;
            }
        }
        switch (join) {
            case 2: {
                lineJoin = 4096L;
                break;
            }
            default: {
                lineJoin = 8192L;
                break;
            }
            case 1: {
                lineJoin = 0L;
            }
        }
        return this.selectStylePen(this.getPrintDC(), endCap, lineJoin, width, (int)(rgb[0] * 255.0f), (int)(rgb[1] * 255.0f), (int)(rgb[2] * 255.0f));
    }

    protected boolean setFont(String family, float size, int style, int rotation, float awScale) {
        boolean didSetFont = true;
        if ((!family.equals(this.mLastFontFamily) || size != this.mLastFontSize || style != this.mLastFontStyle || rotation != this.mLastRotation || awScale != this.mLastAwScale) && (didSetFont = this.setFont(this.getPrintDC(), family, size, (style & 1) != 0, (style & 2) != 0, rotation, awScale))) {
            this.mLastFontFamily = family;
            this.mLastFontSize = size;
            this.mLastFontStyle = style;
            this.mLastRotation = rotation;
            this.mLastAwScale = awScale;
        }
        return didSetFont;
    }

    protected void setTextColor(Color color) {
        if (!color.equals(this.mLastTextColor)) {
            this.mLastTextColor = color;
            float[] rgb = color.getRGBColorComponents(null);
            this.setTextColor(this.getPrintDC(), (int)(rgb[0] * 255.0f), (int)(rgb[1] * 255.0f), (int)(rgb[2] * 255.0f));
        }
    }

    @Override
    protected String removeControlChars(String str) {
        return super.removeControlChars(str);
    }

    protected void textOut(String str, float x, float y, float[] positions) {
        String text = this.removeControlChars(str);
        assert (positions == null || text.length() == str.length());
        if (text.length() == 0) {
            return;
        }
        this.textOut(this.getPrintDC(), text, text.length(), false, x, y, positions);
    }

    protected void glyphsOut(int[] glyphs, float x, float y, float[] positions) {
        char[] glyphCharArray = new char[glyphs.length];
        for (int i = 0; i < glyphs.length; ++i) {
            glyphCharArray[i] = (char)(glyphs[i] & 0xFFFF);
        }
        String glyphStr = new String(glyphCharArray);
        this.textOut(this.getPrintDC(), glyphStr, glyphs.length, true, x, y, positions);
    }

    protected int getGDIAdvance(String text) {
        if ((text = this.removeControlChars(text)).length() == 0) {
            return 0;
        }
        return this.getGDIAdvance(this.getPrintDC(), text);
    }

    protected void drawImage3ByteBGR(byte[] image, float destX, float destY, float destWidth, float destHeight, float srcX, float srcY, float srcWidth, float srcHeight) {
        this.drawDIBImage(this.getPrintDC(), image, destX, destY, destWidth, destHeight, srcX, srcY, srcWidth, srcHeight, 24, null);
    }

    protected void drawDIBImage(byte[] image, float destX, float destY, float destWidth, float destHeight, float srcX, float srcY, float srcWidth, float srcHeight, int sampleBitsPerPixel, IndexColorModel icm) {
        int bitCount = 24;
        byte[] bmiColors = null;
        if (icm != null) {
            bitCount = sampleBitsPerPixel;
            bmiColors = new byte[(1 << icm.getPixelSize()) * 4];
            for (int i = 0; i < icm.getMapSize(); ++i) {
                bmiColors[i * 4 + 0] = (byte)(icm.getBlue(i) & 0xFF);
                bmiColors[i * 4 + 1] = (byte)(icm.getGreen(i) & 0xFF);
                bmiColors[i * 4 + 2] = (byte)(icm.getRed(i) & 0xFF);
            }
        }
        this.drawDIBImage(this.getPrintDC(), image, destX, destY, destWidth, destHeight, srcX, srcY, srcWidth, srcHeight, bitCount, bmiColors);
    }

    @Override
    protected void startPage(PageFormat format, Printable painter, int index, boolean paperChanged) {
        this.invalidateCachedState();
        this.deviceStartPage(format, painter, index, paperChanged);
    }

    @Override
    protected void endPage(PageFormat format, Printable painter, int index) {
        this.deviceEndPage(format, painter, index);
    }

    private void invalidateCachedState() {
        this.mLastColor = null;
        this.mLastTextColor = null;
        this.mLastFontFamily = null;
    }

    @Override
    public void setCopies(int copies) {
        super.setCopies(copies);
        this.defaultCopies = false;
        this.mAttCopies = copies;
        this.setNativeCopies(copies);
    }

    private native void setNativeCopies(int var1);

    private native boolean jobSetup(Pageable var1, boolean var2);

    @Override
    protected native void initPrinter();

    private native boolean _startDoc(String var1, String var2) throws PrinterException;

    @Override
    protected void startDoc() throws PrinterException {
        if (!this._startDoc(this.mDestination, this.getJobName())) {
            this.cancel();
        }
    }

    @Override
    protected native void endDoc();

    @Override
    protected native void abortDoc();

    private static native void deleteDC(long var0, long var2, long var4);

    protected native void deviceStartPage(PageFormat var1, Printable var2, int var3, boolean var4);

    protected native void deviceEndPage(PageFormat var1, Printable var2, int var3);

    @Override
    protected native void printBand(byte[] var1, int var2, int var3, int var4, int var5);

    protected native void beginPath(long var1);

    protected native void endPath(long var1);

    protected native void closeFigure(long var1);

    protected native void fillPath(long var1);

    protected native void moveTo(long var1, float var3, float var4);

    protected native void lineTo(long var1, float var3, float var4);

    protected native void polyBezierTo(long var1, float var3, float var4, float var5, float var6, float var7, float var8);

    protected native void setPolyFillMode(long var1, int var3);

    protected native void selectSolidBrush(long var1, int var3, int var4, int var5);

    protected native int getPenX(long var1);

    protected native int getPenY(long var1);

    protected native void selectClipPath(long var1);

    protected native void frameRect(long var1, float var3, float var4, float var5, float var6);

    protected native void fillRect(long var1, float var3, float var4, float var5, float var6, int var7, int var8, int var9);

    protected native void selectPen(long var1, float var3, int var4, int var5, int var6);

    protected native boolean selectStylePen(long var1, long var3, long var5, float var7, int var8, int var9, int var10);

    protected native boolean setFont(long var1, String var3, float var4, boolean var5, boolean var6, int var7, float var8);

    protected native void setTextColor(long var1, int var3, int var4, int var5);

    protected native void textOut(long var1, String var3, int var4, boolean var5, float var6, float var7, float[] var8);

    private native int getGDIAdvance(long var1, String var3);

    private native void drawDIBImage(long var1, byte[] var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, int var12, byte[] var13);

    private final String getPrinterAttrib() {
        PrintService service = this.getPrintService();
        String name = service != null ? service.getName() : null;
        return name;
    }

    private final int getCollateAttrib() {
        return this.mAttCollate;
    }

    private void setCollateAttrib(Attribute attr) {
        this.mAttCollate = attr == SheetCollate.COLLATED ? 1 : 0;
    }

    private void setCollateAttrib(Attribute attr, PrintRequestAttributeSet set) {
        this.setCollateAttrib(attr);
        set.add(attr);
    }

    private final int getOrientAttrib() {
        OrientationRequested orientReq;
        int orient = 1;
        OrientationRequested orientationRequested = orientReq = this.attributes == null ? null : (OrientationRequested)this.attributes.get(OrientationRequested.class);
        if (orientReq == null) {
            orientReq = (OrientationRequested)this.myService.getDefaultAttributeValue(OrientationRequested.class);
        }
        if (orientReq != null) {
            if (orientReq == OrientationRequested.REVERSE_LANDSCAPE) {
                orient = 2;
            } else if (orientReq == OrientationRequested.LANDSCAPE) {
                orient = 0;
            }
        }
        return orient;
    }

    private void setOrientAttrib(Attribute attr, PrintRequestAttributeSet set) {
        if (set != null) {
            set.add(attr);
        }
    }

    private final int getCopiesAttrib() {
        if (this.defaultCopies) {
            return 0;
        }
        return this.getCopiesInt();
    }

    private final void setRangeCopiesAttribute(int from, int to, boolean isRangeSet, int copies) {
        if (this.attributes != null) {
            if (isRangeSet) {
                this.attributes.add(new PageRanges(from, to));
                this.setPageRange(from, to);
            }
            this.defaultCopies = false;
            this.attributes.add(new Copies(copies));
            super.setCopies(copies);
            this.mAttCopies = copies;
        }
    }

    private final boolean getDestAttrib() {
        return this.mDestination != null;
    }

    private final int getQualityAttrib() {
        return this.mAttQuality;
    }

    private void setQualityAttrib(Attribute attr) {
        this.mAttQuality = attr == PrintQuality.HIGH ? -4 : (attr == PrintQuality.NORMAL ? -3 : -2);
    }

    private void setQualityAttrib(Attribute attr, PrintRequestAttributeSet set) {
        this.setQualityAttrib(attr);
        set.add(attr);
    }

    private final int getColorAttrib() {
        return this.mAttChromaticity;
    }

    private void setColorAttrib(Attribute attr) {
        this.mAttChromaticity = attr == Chromaticity.COLOR ? 2 : 1;
    }

    private void setColorAttrib(Attribute attr, PrintRequestAttributeSet set) {
        this.setColorAttrib(attr);
        set.add(attr);
    }

    private final int getSidesAttrib() {
        return this.mAttSides;
    }

    private void setSidesAttrib(Attribute attr) {
        this.mAttSides = attr == Sides.TWO_SIDED_LONG_EDGE ? 2 : (attr == Sides.TWO_SIDED_SHORT_EDGE ? 3 : 1);
    }

    private void setSidesAttrib(Attribute attr, PrintRequestAttributeSet set) {
        this.setSidesAttrib(attr);
        set.add(attr);
    }

    private final int[] getWin32MediaAttrib() {
        MediaSizeName msn;
        MediaSize ms;
        Media media;
        int[] wid_ht = new int[]{0, 0};
        if (this.attributes != null && (media = (Media)this.attributes.get(Media.class)) instanceof MediaSizeName && (ms = MediaSize.getMediaSizeForName(msn = (MediaSizeName)media)) != null) {
            wid_ht[0] = (int)((double)ms.getX(25400) * 72.0);
            wid_ht[1] = (int)((double)ms.getY(25400) * 72.0);
        }
        return wid_ht;
    }

    private void setWin32MediaAttrib(Attribute attr) {
        if (!(attr instanceof MediaSizeName)) {
            return;
        }
        MediaSizeName msn = (MediaSizeName)attr;
        this.mAttMediaSizeName = ((Win32PrintService)this.myService).findPaperID(msn);
    }

    private void addPaperSize(PrintRequestAttributeSet aset, int dmIndex, int width, int length) {
        if (aset == null) {
            return;
        }
        MediaSizeName msn = ((Win32PrintService)this.myService).findWin32Media(dmIndex);
        if (msn == null) {
            msn = ((Win32PrintService)this.myService).findMatchingMediaSizeNameMM(width, length);
        }
        if (msn != null) {
            aset.add(msn);
        }
    }

    private void setWin32MediaAttrib(int dmIndex, int width, int length) {
        this.addPaperSize(this.attributes, dmIndex, width, length);
        this.mAttMediaSizeName = dmIndex;
    }

    private void setMediaTrayAttrib(Attribute attr) {
        this.mAttMediaTray = attr == MediaTray.BOTTOM ? 2 : (attr == MediaTray.ENVELOPE ? 5 : (attr == MediaTray.LARGE_CAPACITY ? 11 : (attr == MediaTray.MAIN ? 1 : (attr == MediaTray.MANUAL ? 4 : (attr == MediaTray.MIDDLE ? 3 : (attr == MediaTray.SIDE ? 7 : (attr == MediaTray.TOP ? 1 : (attr instanceof Win32MediaTray ? ((Win32MediaTray)attr).winID : 1))))))));
    }

    private void setMediaTrayAttrib(int dmBinID) {
        this.mAttMediaTray = dmBinID;
        MediaTray tray = ((Win32PrintService)this.myService).findMediaTray(dmBinID);
    }

    private int getMediaTrayAttrib() {
        return this.mAttMediaTray;
    }

    private final boolean getPrintToFileEnabled() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            FilePermission printToFilePermission = new FilePermission("<<ALL FILES>>", "read,write");
            try {
                security.checkPermission(printToFilePermission);
            }
            catch (SecurityException e) {
                return false;
            }
        }
        return true;
    }

    private final void setNativeAttributes(int flags, int fields, int values) {
        if (this.attributes == null) {
            return;
        }
        if ((flags & 0x20) != 0) {
            Destination destPrn = (Destination)this.attributes.get(Destination.class);
            if (destPrn == null) {
                try {
                    this.attributes.add(new Destination(new File("./out.prn").toURI()));
                }
                catch (SecurityException se) {
                    try {
                        this.attributes.add(new Destination(new URI("file:out.prn")));
                    }
                    catch (URISyntaxException uRISyntaxException) {}
                }
            }
        } else {
            this.attributes.remove(Destination.class);
        }
        if ((flags & 0x10) != 0) {
            this.setCollateAttrib(SheetCollate.COLLATED, this.attributes);
        } else {
            this.setCollateAttrib(SheetCollate.UNCOLLATED, this.attributes);
        }
        if ((flags & 2) != 0) {
            this.attributes.add(SunPageSelection.RANGE);
        } else if ((flags & 1) != 0) {
            this.attributes.add(SunPageSelection.SELECTION);
        } else {
            this.attributes.add(SunPageSelection.ALL);
        }
        if ((fields & 1) != 0) {
            if ((values & 0x4000) != 0) {
                this.setOrientAttrib(OrientationRequested.LANDSCAPE, this.attributes);
            } else {
                this.setOrientAttrib(OrientationRequested.PORTRAIT, this.attributes);
            }
        }
        if ((fields & 0x800) != 0) {
            if ((values & 0x200) != 0) {
                this.setColorAttrib(Chromaticity.COLOR, this.attributes);
            } else {
                this.setColorAttrib(Chromaticity.MONOCHROME, this.attributes);
            }
        }
        if ((fields & 0x400) != 0) {
            PrintQuality quality = (values & 0x80) != 0 ? PrintQuality.DRAFT : ((fields & 0x40) != 0 ? PrintQuality.HIGH : PrintQuality.NORMAL);
            this.setQualityAttrib(quality, this.attributes);
        }
        if ((fields & 0x1000) != 0) {
            Sides sides = (values & 0x10) != 0 ? Sides.TWO_SIDED_LONG_EDGE : ((values & 0x20) != 0 ? Sides.TWO_SIDED_SHORT_EDGE : Sides.ONE_SIDED);
            this.setSidesAttrib(sides, this.attributes);
        }
    }

    private void getDevModeValues(PrintRequestAttributeSet aset, DevModeValues info) {
        PrinterResolution r;
        PrintQuality q;
        SunAlternateMedia sam;
        Media m;
        OrientationRequested or;
        Sides s;
        Chromaticity ch;
        SheetCollate sc;
        Copies c = (Copies)aset.get(Copies.class);
        if (c != null) {
            info.dmFields |= 0x100;
            info.copies = (short)c.getValue();
        }
        if ((sc = (SheetCollate)aset.get(SheetCollate.class)) != null) {
            info.dmFields |= 0x8000;
            short s2 = info.collate = sc == SheetCollate.COLLATED ? (short)1 : 0;
        }
        if ((ch = (Chromaticity)aset.get(Chromaticity.class)) != null) {
            info.dmFields |= 0x800;
            info.color = ch == Chromaticity.COLOR ? (short)2 : (short)1;
        }
        if ((s = (Sides)aset.get(Sides.class)) != null) {
            info.dmFields |= 0x1000;
            info.duplex = s == Sides.TWO_SIDED_LONG_EDGE ? (short)2 : (s == Sides.TWO_SIDED_SHORT_EDGE ? (short)3 : (short)1);
        }
        if ((or = (OrientationRequested)aset.get(OrientationRequested.class)) != null) {
            info.dmFields |= 1;
            info.orient = (short)(or == OrientationRequested.LANDSCAPE ? 2 : 1);
        }
        if ((m = (Media)aset.get(Media.class)) instanceof MediaSizeName) {
            info.dmFields |= 2;
            MediaSizeName msn = (MediaSizeName)m;
            info.paper = (short)((Win32PrintService)this.myService).findPaperID(msn);
        }
        MediaTray mt = null;
        if (m instanceof MediaTray) {
            mt = (MediaTray)m;
        }
        if (mt == null && (sam = (SunAlternateMedia)aset.get(SunAlternateMedia.class)) != null && sam.getMedia() instanceof MediaTray) {
            mt = (MediaTray)sam.getMedia();
        }
        if (mt != null) {
            info.dmFields |= 0x200;
            info.bin = (short)((Win32PrintService)this.myService).findTrayID(mt);
        }
        if ((q = (PrintQuality)aset.get(PrintQuality.class)) != null) {
            info.dmFields |= 0x400;
            info.xres_quality = q == PrintQuality.DRAFT ? (short)-1 : (q == PrintQuality.HIGH ? (short)-4 : (short)-3);
        }
        if ((r = (PrinterResolution)aset.get(PrinterResolution.class)) != null) {
            info.dmFields |= 0x2400;
            info.xres_quality = (short)r.getCrossFeedResolution(100);
            info.yres = (short)r.getFeedResolution(100);
        }
    }

    private final void setJobAttributes(PrintRequestAttributeSet attributes, int fields, int values, short copies, short dmPaperSize, short dmPaperWidth, short dmPaperLength, short dmDefaultSource, short xRes, short yRes) {
        if (attributes == null) {
            return;
        }
        if ((fields & 0x100) != 0) {
            attributes.add(new Copies(copies));
        }
        if ((fields & 0x8000) != 0) {
            if ((values & 0x8000) != 0) {
                attributes.add(SheetCollate.COLLATED);
            } else {
                attributes.add(SheetCollate.UNCOLLATED);
            }
        }
        if ((fields & 1) != 0) {
            if ((values & 0x4000) != 0) {
                attributes.add(OrientationRequested.LANDSCAPE);
            } else {
                attributes.add(OrientationRequested.PORTRAIT);
            }
        }
        if ((fields & 0x800) != 0) {
            if ((values & 0x200) != 0) {
                attributes.add(Chromaticity.COLOR);
            } else {
                attributes.add(Chromaticity.MONOCHROME);
            }
        }
        if ((fields & 0x400) != 0) {
            if (xRes < 0) {
                PrintQuality quality = (values & 0x80) != 0 ? PrintQuality.DRAFT : ((fields & 0x40) != 0 ? PrintQuality.HIGH : PrintQuality.NORMAL);
                attributes.add(quality);
            } else if (xRes > 0 && yRes > 0) {
                attributes.add(new PrinterResolution(xRes, yRes, 100));
            }
        }
        if ((fields & 0x1000) != 0) {
            Sides sides = (values & 0x10) != 0 ? Sides.TWO_SIDED_LONG_EDGE : ((values & 0x20) != 0 ? Sides.TWO_SIDED_SHORT_EDGE : Sides.ONE_SIDED);
            attributes.add(sides);
        }
        if ((fields & 2) != 0) {
            this.addPaperSize(attributes, dmPaperSize, dmPaperWidth, dmPaperLength);
        }
        if ((fields & 0x200) != 0) {
            MediaTray tray = ((Win32PrintService)this.myService).findMediaTray(dmDefaultSource);
            attributes.add(new SunAlternateMedia(tray));
        }
    }

    private native boolean showDocProperties(long var1, PrintRequestAttributeSet var3, int var4, short var5, short var6, short var7, short var8, short var9, short var10, short var11, short var12, short var13);

    public PrintRequestAttributeSet showDocumentProperties(Window owner, PrintService service, PrintRequestAttributeSet aset) {
        try {
            this.setNativePrintServiceIfNeeded(service.getName());
        }
        catch (PrinterException printerException) {
            // empty catch block
        }
        long hWnd = ((WWindowPeer)owner.getPeer()).getHWnd();
        DevModeValues info = new DevModeValues();
        this.getDevModeValues(aset, info);
        boolean ok = this.showDocProperties(hWnd, aset, info.dmFields, info.copies, info.collate, info.color, info.duplex, info.orient, info.paper, info.bin, info.xres_quality, info.yres);
        if (ok) {
            return aset;
        }
        return null;
    }

    private final void setResolutionDPI(int xres, int yres) {
        if (this.attributes != null) {
            PrinterResolution res = new PrinterResolution(xres, yres, 100);
            this.attributes.add(res);
        }
        this.mAttXRes = xres;
        this.mAttYRes = yres;
    }

    private void setResolutionAttrib(Attribute attr) {
        PrinterResolution pr = (PrinterResolution)attr;
        this.mAttXRes = pr.getCrossFeedResolution(100);
        this.mAttYRes = pr.getFeedResolution(100);
    }

    private void setPrinterNameAttrib(String printerName) {
        PrintService service = this.getPrintService();
        if (printerName == null) {
            return;
        }
        if (service != null && printerName.equals(service.getName())) {
            return;
        }
        PrintService[] services = PrinterJob.lookupPrintServices();
        for (int i = 0; i < services.length; ++i) {
            if (!printerName.equals(services[i].getName())) continue;
            try {
                this.setPrintService(services[i]);
            }
            catch (PrinterException printerException) {
                // empty catch block
            }
            return;
        }
    }

    private static native void initIDs();

    static {
        Toolkit.getDefaultToolkit();
        WPrinterJob.initIDs();
        Win32FontManager.registerJREFontsForPrinting();
    }

    class PrintToFileErrorDialog
    extends Dialog
    implements ActionListener {
        public PrintToFileErrorDialog(Frame parent, String title, String message, String buttonText) {
            super(parent, title, true);
            this.init(parent, title, message, buttonText);
        }

        public PrintToFileErrorDialog(Dialog parent, String title, String message, String buttonText) {
            super(parent, title, true);
            this.init(parent, title, message, buttonText);
        }

        private void init(Component parent, String title, String message, String buttonText) {
            Panel p = new Panel();
            this.add("Center", new Label(message));
            Button btn = new Button(buttonText);
            btn.addActionListener(this);
            p.add(btn);
            this.add("South", p);
            this.pack();
            Dimension dDim = this.getSize();
            if (parent != null) {
                Rectangle fRect = parent.getBounds();
                this.setLocation(fRect.x + (fRect.width - dDim.width) / 2, fRect.y + (fRect.height - dDim.height) / 2);
            }
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private static final class DevModeValues {
        int dmFields;
        short copies;
        short collate;
        short color;
        short duplex;
        short orient;
        short paper;
        short bin;
        short xres_quality;
        short yres;

        private DevModeValues() {
        }
    }

    static class HandleRecord
    implements DisposerRecord {
        private long mPrintDC;
        private long mPrintHDevMode;
        private long mPrintHDevNames;

        HandleRecord() {
        }

        @Override
        public void dispose() {
            WPrinterJob.deleteDC(this.mPrintDC, this.mPrintHDevMode, this.mPrintHDevNames);
        }
    }
}

