/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.nio.fs.AbstractFileTypeDetector;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.WindowsNativeDispatcher;

public class RegistryFileTypeDetector
extends AbstractFileTypeDetector {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String implProbeContentType(Path file) throws IOException {
        if (!(file instanceof Path)) {
            return null;
        }
        Path name = file.getFileName();
        if (name == null) {
            return null;
        }
        String filename = name.toString();
        int dot = filename.lastIndexOf(46);
        if (dot < 0 || dot == filename.length() - 1) {
            return null;
        }
        String key = filename.substring(dot);
        NativeBuffer keyBuffer = WindowsNativeDispatcher.asNativeBuffer(key);
        NativeBuffer nameBuffer = WindowsNativeDispatcher.asNativeBuffer("Content Type");
        try {
            String string = RegistryFileTypeDetector.queryStringValue(keyBuffer.address(), nameBuffer.address());
            return string;
        }
        finally {
            nameBuffer.release();
            keyBuffer.release();
        }
    }

    private static native String queryStringValue(long var0, long var2);

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("net");
                System.loadLibrary("nio");
                return null;
            }
        });
    }
}

