/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import com.sun.nio.file.ExtendedWatchEventModifier;
import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.IOException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import sun.misc.Unsafe;
import sun.nio.fs.AbstractPoller;
import sun.nio.fs.AbstractWatchKey;
import sun.nio.fs.AbstractWatchService;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.NativeBuffers;
import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsFileAttributes;
import sun.nio.fs.WindowsFileSystem;
import sun.nio.fs.WindowsNativeDispatcher;
import sun.nio.fs.WindowsPath;

class WindowsWatchService
extends AbstractWatchService {
    private static final int WAKEUP_COMPLETION_KEY = 0;
    private final Poller poller;
    private static final int ALL_FILE_NOTIFY_EVENTS = 351;

    WindowsWatchService(WindowsFileSystem fs) throws IOException {
        long port = 0L;
        try {
            port = WindowsNativeDispatcher.CreateIoCompletionPort(-1L, 0L, 0L);
        }
        catch (WindowsException x) {
            throw new IOException(x.getMessage());
        }
        this.poller = new Poller(fs, this, port);
        this.poller.start();
    }

    @Override
    WatchKey register(Path path, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        return this.poller.register(path, events, modifiers);
    }

    @Override
    void implClose() throws IOException {
        this.poller.close();
    }

    private static class Poller
    extends AbstractPoller {
        private static final Unsafe UNSAFE = Unsafe.getUnsafe();
        private static final short SIZEOF_DWORD = 4;
        private static final short SIZEOF_OVERLAPPED = 32;
        private static final short OFFSETOF_HEVENT = (short)(UNSAFE.addressSize() == 4 ? 16 : 24);
        private static final short OFFSETOF_NEXTENTRYOFFSET = 0;
        private static final short OFFSETOF_ACTION = 4;
        private static final short OFFSETOF_FILENAMELENGTH = 8;
        private static final short OFFSETOF_FILENAME = 12;
        private static final int CHANGES_BUFFER_SIZE = 16384;
        private final WindowsFileSystem fs;
        private final WindowsWatchService watcher;
        private final long port;
        private final Map<Integer, WindowsWatchKey> ck2key;
        private final Map<FileKey, WindowsWatchKey> fk2key;
        private int lastCompletionKey;

        Poller(WindowsFileSystem fs, WindowsWatchService watcher, long port) {
            this.fs = fs;
            this.watcher = watcher;
            this.port = port;
            this.ck2key = new HashMap<Integer, WindowsWatchKey>();
            this.fk2key = new HashMap<FileKey, WindowsWatchKey>();
            this.lastCompletionKey = 0;
        }

        @Override
        void wakeup() throws IOException {
            try {
                WindowsNativeDispatcher.PostQueuedCompletionStatus(this.port, 0L);
            }
            catch (WindowsException x) {
                throw new IOException(x.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Object implRegister(Path obj, Set<? extends WatchEvent.Kind<?>> events, WatchEvent.Modifier ... modifiers) {
            long handle;
            WindowsPath dir = (WindowsPath)obj;
            boolean watchSubtree = false;
            for (WatchEvent.Modifier modifier : modifiers) {
                if (modifier == ExtendedWatchEventModifier.FILE_TREE) {
                    watchSubtree = true;
                    continue;
                }
                if (modifier == null) {
                    return new NullPointerException();
                }
                if (modifier instanceof SensitivityWatchEventModifier) continue;
                return new UnsupportedOperationException("Modifier not supported");
            }
            try {
                handle = WindowsNativeDispatcher.CreateFile(dir.getPathForWin32Calls(), 1, 7, 3, 0x42000000);
            }
            catch (WindowsException x) {
                return x.asIOException(dir);
            }
            boolean registered = false;
            try {
                WindowsWatchKey watchKey;
                int completionKey;
                WindowsFileAttributes attrs;
                try {
                    attrs = WindowsFileAttributes.readAttributes(handle);
                }
                catch (WindowsException x) {
                    IOException iOException = x.asIOException(dir);
                    if (!registered) {
                        WindowsNativeDispatcher.CloseHandle(handle);
                    }
                    return iOException;
                }
                if (!attrs.isDirectory()) {
                    NotDirectoryException x = new NotDirectoryException(dir.getPathForExceptionMessage());
                    return x;
                }
                FileKey fk = new FileKey(attrs.volSerialNumber(), attrs.fileIndexHigh(), attrs.fileIndexLow());
                WindowsWatchKey existing = this.fk2key.get(fk);
                if (existing != null && watchSubtree == existing.watchSubtree()) {
                    existing.setEvents(events);
                    WindowsWatchKey windowsWatchKey = existing;
                    return windowsWatchKey;
                }
                ++this.lastCompletionKey;
                if ((completionKey = this.lastCompletionKey++) == 0) {
                    completionKey = this.lastCompletionKey;
                }
                try {
                    WindowsNativeDispatcher.CreateIoCompletionPort(handle, this.port, completionKey);
                }
                catch (WindowsException x) {
                    IOException iOException = new IOException(x.getMessage());
                    if (!registered) {
                        WindowsNativeDispatcher.CloseHandle(handle);
                    }
                    return iOException;
                }
                int size = 16420;
                NativeBuffer buffer = NativeBuffers.getNativeBuffer(size);
                long bufferAddress = buffer.address();
                long overlappedAddress = bufferAddress + (long)size - 32L;
                long countAddress = overlappedAddress - 4L;
                UNSAFE.setMemory(overlappedAddress, 32L, (byte)0);
                try {
                    this.createAndAttachEvent(overlappedAddress);
                    WindowsNativeDispatcher.ReadDirectoryChangesW(handle, bufferAddress, 16384, watchSubtree, 351, countAddress, overlappedAddress);
                }
                catch (WindowsException x) {
                    this.closeAttachedEvent(overlappedAddress);
                    buffer.release();
                    IOException iOException = new IOException(x.getMessage());
                    if (!registered) {
                        WindowsNativeDispatcher.CloseHandle(handle);
                    }
                    return iOException;
                }
                if (existing == null) {
                    watchKey = new WindowsWatchKey(dir, this.watcher, fk).init(handle, events, watchSubtree, buffer, countAddress, overlappedAddress, completionKey);
                    this.fk2key.put(fk, watchKey);
                } else {
                    this.ck2key.remove(existing.completionKey());
                    this.releaseResources(existing);
                    watchKey = existing.init(handle, events, watchSubtree, buffer, countAddress, overlappedAddress, completionKey);
                }
                this.ck2key.put(completionKey, watchKey);
                registered = true;
                WindowsWatchKey windowsWatchKey = watchKey;
                return windowsWatchKey;
            }
            finally {
                if (!registered) {
                    WindowsNativeDispatcher.CloseHandle(handle);
                }
            }
        }

        private void releaseResources(WindowsWatchKey key) {
            try {
                WindowsNativeDispatcher.CancelIo(key.handle());
                if (!key.isErrorStartingOverlapped()) {
                    WindowsNativeDispatcher.GetOverlappedResult(key.handle(), key.overlappedAddress());
                }
            }
            catch (WindowsException windowsException) {
                // empty catch block
            }
            WindowsNativeDispatcher.CloseHandle(key.handle());
            this.closeAttachedEvent(key.overlappedAddress());
            key.buffer().cleaner().clean();
        }

        private void createAndAttachEvent(long ov) throws WindowsException {
            long hEvent = WindowsNativeDispatcher.CreateEvent(false, false);
            UNSAFE.putAddress(ov + (long)OFFSETOF_HEVENT, hEvent);
        }

        private void closeAttachedEvent(long ov) {
            long hEvent = UNSAFE.getAddress(ov + (long)OFFSETOF_HEVENT);
            if (hEvent != 0L && hEvent != -1L) {
                WindowsNativeDispatcher.CloseHandle(hEvent);
            }
        }

        @Override
        void implCancelKey(WatchKey obj) {
            WindowsWatchKey key = (WindowsWatchKey)obj;
            if (key.isValid()) {
                this.fk2key.remove(key.fileKey());
                this.ck2key.remove(key.completionKey());
                key.invalidate();
            }
        }

        @Override
        void implCloseAll() {
            this.ck2key.values().forEach(WindowsWatchKey::invalidate);
            this.fk2key.clear();
            this.ck2key.clear();
            WindowsNativeDispatcher.CloseHandle(this.port);
        }

        private WatchEvent.Kind<?> translateActionToEvent(int action) {
            switch (action) {
                case 3: {
                    return StandardWatchEventKinds.ENTRY_MODIFY;
                }
                case 1: 
                case 5: {
                    return StandardWatchEventKinds.ENTRY_CREATE;
                }
                case 2: 
                case 4: {
                    return StandardWatchEventKinds.ENTRY_DELETE;
                }
            }
            return null;
        }

        private void processEvents(WindowsWatchKey key, int size) {
            int nextOffset;
            long address = key.buffer().address();
            do {
                int action = UNSAFE.getInt(address + 4L);
                WatchEvent.Kind<?> kind = this.translateActionToEvent(action);
                if (key.events().contains(kind)) {
                    int nameLengthInBytes = UNSAFE.getInt(address + 8L);
                    if (nameLengthInBytes % 2 != 0) {
                        throw new AssertionError((Object)"FileNameLength is not a multiple of 2");
                    }
                    char[] nameAsArray = new char[nameLengthInBytes / 2];
                    UNSAFE.copyMemory(null, address + 12L, nameAsArray, Unsafe.ARRAY_CHAR_BASE_OFFSET, nameLengthInBytes);
                    WindowsPath name = WindowsPath.createFromNormalizedPath(this.fs, new String(nameAsArray));
                    key.signalEvent(kind, name);
                }
                nextOffset = UNSAFE.getInt(address + 0L);
                address += (long)nextOffset;
            } while (nextOffset != 0);
        }

        @Override
        public void run() {
            while (true) {
                WindowsNativeDispatcher.CompletionStatus info;
                try {
                    info = WindowsNativeDispatcher.GetQueuedCompletionStatus(this.port);
                }
                catch (WindowsException x) {
                    x.printStackTrace();
                    return;
                }
                if (info.completionKey() == 0L) {
                    boolean shutdown = this.processRequests();
                    if (!shutdown) continue;
                    return;
                }
                WindowsWatchKey key = this.ck2key.get((int)info.completionKey());
                if (key == null) continue;
                boolean criticalError = false;
                int errorCode = info.error();
                int messageSize = info.bytesTransferred();
                if (errorCode == 1022) {
                    key.signalEvent(StandardWatchEventKinds.OVERFLOW, null);
                } else if (errorCode != 0 && errorCode != 234) {
                    criticalError = true;
                } else {
                    if (messageSize > 0) {
                        this.processEvents(key, messageSize);
                    } else if (errorCode == 0) {
                        key.signalEvent(StandardWatchEventKinds.OVERFLOW, null);
                    }
                    try {
                        WindowsNativeDispatcher.ReadDirectoryChangesW(key.handle(), key.buffer().address(), 16384, key.watchSubtree(), 351, key.countAddress(), key.overlappedAddress());
                    }
                    catch (WindowsException x) {
                        criticalError = true;
                        key.setErrorStartingOverlapped(true);
                    }
                }
                if (!criticalError) continue;
                this.implCancelKey(key);
                key.signal();
            }
        }
    }

    private static class FileKey {
        private final int volSerialNumber;
        private final int fileIndexHigh;
        private final int fileIndexLow;

        FileKey(int volSerialNumber, int fileIndexHigh, int fileIndexLow) {
            this.volSerialNumber = volSerialNumber;
            this.fileIndexHigh = fileIndexHigh;
            this.fileIndexLow = fileIndexLow;
        }

        public int hashCode() {
            return this.volSerialNumber ^ this.fileIndexHigh ^ this.fileIndexLow;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof FileKey)) {
                return false;
            }
            FileKey other = (FileKey)obj;
            if (this.volSerialNumber != other.volSerialNumber) {
                return false;
            }
            if (this.fileIndexHigh != other.fileIndexHigh) {
                return false;
            }
            return this.fileIndexLow == other.fileIndexLow;
        }
    }

    private static class WindowsWatchKey
    extends AbstractWatchKey {
        private final FileKey fileKey;
        private volatile long handle = -1L;
        private Set<? extends WatchEvent.Kind<?>> events;
        private boolean watchSubtree;
        private NativeBuffer buffer;
        private long countAddress;
        private long overlappedAddress;
        private int completionKey;
        private boolean errorStartingOverlapped;

        WindowsWatchKey(Path dir, AbstractWatchService watcher, FileKey fileKey) {
            super(dir, watcher);
            this.fileKey = fileKey;
        }

        WindowsWatchKey init(long handle, Set<? extends WatchEvent.Kind<?>> events, boolean watchSubtree, NativeBuffer buffer, long countAddress, long overlappedAddress, int completionKey) {
            this.handle = handle;
            this.events = events;
            this.watchSubtree = watchSubtree;
            this.buffer = buffer;
            this.countAddress = countAddress;
            this.overlappedAddress = overlappedAddress;
            this.completionKey = completionKey;
            return this;
        }

        long handle() {
            return this.handle;
        }

        Set<? extends WatchEvent.Kind<?>> events() {
            return this.events;
        }

        void setEvents(Set<? extends WatchEvent.Kind<?>> events) {
            this.events = events;
        }

        boolean watchSubtree() {
            return this.watchSubtree;
        }

        NativeBuffer buffer() {
            return this.buffer;
        }

        long countAddress() {
            return this.countAddress;
        }

        long overlappedAddress() {
            return this.overlappedAddress;
        }

        FileKey fileKey() {
            return this.fileKey;
        }

        int completionKey() {
            return this.completionKey;
        }

        void setErrorStartingOverlapped(boolean value) {
            this.errorStartingOverlapped = value;
        }

        boolean isErrorStartingOverlapped() {
            return this.errorStartingOverlapped;
        }

        void invalidate() {
            ((WindowsWatchService)this.watcher()).poller.releaseResources(this);
            this.handle = -1L;
            this.buffer = null;
            this.countAddress = 0L;
            this.overlappedAddress = 0L;
            this.errorStartingOverlapped = false;
        }

        @Override
        public boolean isValid() {
            return this.handle != -1L;
        }

        @Override
        public void cancel() {
            if (this.isValid()) {
                ((WindowsWatchService)this.watcher()).poller.cancel(this);
            }
        }
    }
}

