<?xml version="1.0" encoding="ISO-8859-1"?>
<!-- Edited by XMLSpy® -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:template match="/">
  <html>
  <body>
  <h1>X-Ray Radiation Dose Structured Report</h1>
  <h2>Patient Information</h2>
  <p><b>Patient Name:  </b><xsl:value-of select="report/patient/name/first"/> <xsl:value-of select="report/patient/name/last"/></p>
  <p><b>Patient Id:  </b><xsl:value-of select="report/patient/sex"/></p>
  <p><b>Patient Birthday:  </b><xsl:value-of select="report/patient/birthday/date"/></p>
  <p><b>Patient Sex:  </b><xsl:value-of select="report/patient/sex"/></p>
  <p><b>Referring Physician:  </b><xsl:value-of select="report/referringphysician/name/first"/> <xsl:value-of select="report/referringphysician/name/last"/></p>
  <p><b>Accession No:  </b><xsl:value-of select="report/study/accession/number"/></p>
  <p><b>Study Description:  </b><xsl:value-of select="report/study/description"/></p>
  <p><b>Modality: </b><xsl:value-of select="report/modality"/></p>
  <h2>Equipment Information</h2>
  <p><b>Organization:  </b><xsl:value-of select="report/coding/organization"/></p>
  <p><b>Manufacturer:  </b><xsl:value-of select="report/device/manufacturer"/></p>
  <p><b>Model:  </b><xsl:value-of select="report/device/model"/></p>
  <p><b>Serial No:  </b><xsl:value-of select="report/device/serial"/></p>
  <p><b>Software Version:  </b><xsl:value-of select="report/device/version"/></p>
  <h2>Accumulated Dose</h2>
  <h3>Calibration</h3>
  <p><b>Dose Measurement Device:  </b><xsl:value-of select="report/patient/sex"/></p>
  <p><b>Calibration Date:  </b><xsl:value-of select="report/patient/sex"/></p>
  <p><b>Calibration Factor:  </b><xsl:value-of select="report/patient/sex"/></p>
  <p><b>Calibration Uncertainty:  </b><xsl:value-of select="report/patient/sex"/></p>
  <p><b>Calibration Responsible Party:  </b><xsl:value-of select="report/patient/sex"/></p>
  <p><b>Calibration Factor:  </b><xsl:value-of select="report/patient/sex"/></p>
  <h3>Dose</h3>
  <p><b>DAP Total During The Examination (Radioscopy):</b></p>
  <p><b>DAP Total During The Examination (Radiography):</b></p>
  <p><b>Air Kerma TotalDuring The Examination (Radioscopy):</b></p>
  <p><b>Air Kerma Total During The Examination (Radiography):</b></p>
  <p><b>Total Number Of Radiographic Frames:</b></p>
  <p><b>Total Radioscopy Time:</b></p>
  <h2>Irradiation Event X-Ray Data</h2>
    <table border="1">
      <tr bgcolor="#6D7B8D">
        <th width="8%"><font SIZE="2">Acquistion<br/>Plane</font></th>
        <th WIDTH="8%"><font SIZE="2">Date Time<br/>Started</font></th>
        <th WIDTH="8%"><font SIZE="2">Irradiation<br/>Event Type</font></th>
        <th WIDTH="8%"><font SIZE="2">Acquisition<br/>Protocol</font></th>
        <th WIDTH="4%"><font SIZE="2">DAP</font></th>
        <th WIDTH="4%"><font SIZE="2">Dose(RP)</font></th>
        <th WIDTH="9%"><font SIZE="2">Collimated<br/>Field Area</font></th>
        <th WIDTH="8%"><font SIZE="2">Fluoro<br/>Mode</font></th>
        <th WIDTH="8%"><font SIZE="2">Pulse<br/>Rate</font></th>
        <th WIDTH="4%"><font SIZE="2">kVp</font></th>
        <th WIDTH="4%"><font SIZE="2">mA</font></th>
        <th WIDTH="4%"><font SIZE="2">Exposure</font></th>
        <th WIDTH="7%"><font SIZE="2">Pulse Width</font></th>
        <th WIDTH="9%"><font SIZE="2">Focal<br/>Spot Size</font></th>
        <th WIDTH="7%"><font SIZE="2">Patient<br/>Orientation</font></th>
      </tr>
      <xsl:for-each select="report/document/content/item/item">
      <xsl:if test="concept='Irradiation Event X-Ray Data'">
      <tr>
       <xsl:for-each select="item">
       <xsl:if test="concept='Acquisition Plane'">
        	<td><xsl:value-of select="value"/></td>
       </xsl:if>
       <xsl:if test="concept='Date Time Started'">
        	<td><xsl:value-of select="value"/></td>
       </xsl:if>
       <xsl:if test="concept='Irradiation Event Type'">
        	<td><xsl:value-of select="value"/></td>
       </xsl:if>
       <xsl:if test="concept='Acquisition Protocol'">
        	<td><xsl:value-of select="value"/></td>
       </xsl:if>
       <xsl:if test="concept='Dose Area Product'">
        	<td><xsl:value-of select="value"/></td>
       </xsl:if>
       <xsl:if test="concept='Dose(RP)'">
        	<td><xsl:value-of select="value"/></td>
       </xsl:if>
        <xsl:if test="concept='Collimated Field Area'">
        	<td><xsl:value-of select="value"/></td>
       </xsl:if>
       <xsl:if test="concept='Fluoro Mode'">
        	<td><xsl:value-of select="value"/></td>
       </xsl:if>
       <xsl:if test="concept='Pulse Rate'">
        	<td><xsl:value-of select="value"/></td>
       </xsl:if>
       <xsl:if test="concept='kVp'">
        	<td><xsl:value-of select="value"/></td>
       </xsl:if>
       <xsl:if test="concept='mA'">
        	<td><xsl:value-of select="value"/></td>
       </xsl:if>
       <xsl:if test="concept='Exposure'">
        	<td><xsl:value-of select="value"/></td>
       </xsl:if>
       <xsl:if test="concept='Pulse Width'">
        	<td><xsl:value-of select="value"/></td>
       </xsl:if>
       <xsl:if test="concept='Focal Spot Size'">
        	<td><xsl:value-of select="value"/></td>
       </xsl:if>
       <xsl:if test="concept='Patient Orientation'">
        	<td><xsl:value-of select="value"/></td>
       </xsl:if>
       </xsl:for-each>
      </tr>
      </xsl:if>
      </xsl:for-each>
     </table>
     <h2>Report Summary</h2>
     <p>The plan of treatment is as follows: 4500 rad, 15 treatment sessions, using 100 kV radiation.&#10;<br/>The reason for treatment, expected acute reaction, and remote possibility of complication<br/> was discussed with this patient at some length, and he accepted therapy as outlined.</p>
	  <p><b>Completion Flag: </b><xsl:value-of select="report/document/completion/@flag"/></p>
	  <p><b>Verification Flag: </b><xsl:value-of select="report/document/verification/@flag"/></p>
	  <p><b>Verifying Observers: </b></p>
	  <p><b>Content Date/Time: </b><xsl:value-of select="report/document/content/date"/>/<xsl:value-of select="report/document/content/time"/></p>
  </body>
  </html>
</xsl:template>
</xsl:stylesheet>